/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.syntax.Token;
import org.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractASTTransformUtil
implements Opcodes {
    private static final Token COMPARE_EQUAL = Token.newSymbol(123, -1, -1);
    private static final Token COMPARE_NOT_EQUAL = Token.newSymbol(120, -1, -1);
    private static final Token INSTANCEOF = Token.newSymbol(544, -1, -1);
    private static final Token ASSIGN = Token.newSymbol(100, -1, -1);

    public static boolean hasDeclaredMethod(ClassNode cNode, String name, int argsCount) {
        List<MethodNode> ms = cNode.getDeclaredMethods(name);
        for (MethodNode m : ms) {
            Parameter[] paras = m.getParameters();
            if (paras == null || paras.length != argsCount) continue;
            return true;
        }
        return false;
    }

    public static Statement returnFalseIfWrongType(ClassNode cNode, Expression other) {
        return new IfStatement(AbstractASTTransformUtil.notEqualClasses(cNode, other), new ReturnStatement(new ConstantExpression(Boolean.FALSE)), EmptyStatement.INSTANCE);
    }

    public static Statement returnFalseIfNotInstanceof(ClassNode cNode, Expression other) {
        return new IfStatement(AbstractASTTransformUtil.isInstanceof(cNode, other), EmptyStatement.INSTANCE, new ReturnStatement(new ConstantExpression(Boolean.FALSE)));
    }

    public static IfStatement returnFalseIfNull(Expression other) {
        return new IfStatement(AbstractASTTransformUtil.equalsNullExpr(other), new ReturnStatement(new ConstantExpression(Boolean.FALSE)), EmptyStatement.INSTANCE);
    }

    public static IfStatement returnTrueIfIdentical(Expression self, Expression other) {
        return new IfStatement(AbstractASTTransformUtil.identicalExpr(self, other), new ReturnStatement(new ConstantExpression(Boolean.TRUE)), EmptyStatement.INSTANCE);
    }

    @Deprecated
    public static Statement returnFalseIfPropertyNotEqual(FieldNode fNode, Expression other) {
        return AbstractASTTransformUtil.returnFalseIfFieldNotEqual(fNode, other);
    }

    public static Statement returnFalseIfPropertyNotEqual(PropertyNode pNode, Expression other) {
        return new IfStatement(AbstractASTTransformUtil.notEqualsPropertyExpr(pNode, other), new ReturnStatement(new ConstantExpression(Boolean.FALSE)), EmptyStatement.INSTANCE);
    }

    public static Statement returnFalseIfFieldNotEqual(FieldNode fNode, Expression other) {
        return new IfStatement(AbstractASTTransformUtil.notEqualsFieldExpr(fNode, other), new ReturnStatement(new ConstantExpression(Boolean.FALSE)), EmptyStatement.INSTANCE);
    }

    public static List<PropertyNode> getInstanceProperties(ClassNode cNode) {
        ArrayList<PropertyNode> result = new ArrayList<PropertyNode>();
        for (PropertyNode pNode : cNode.getProperties()) {
            if (pNode.isStatic()) continue;
            result.add(pNode);
        }
        return result;
    }

    public static List<FieldNode> getInstancePropertyFields(ClassNode cNode) {
        ArrayList<FieldNode> result = new ArrayList<FieldNode>();
        for (PropertyNode pNode : cNode.getProperties()) {
            if (pNode.isStatic()) continue;
            result.add(pNode.getField());
        }
        return result;
    }

    public static List<FieldNode> getInstanceNonPropertyFields(ClassNode cNode) {
        ArrayList<FieldNode> result = new ArrayList<FieldNode>();
        for (FieldNode fNode : cNode.getFields()) {
            if (fNode.isStatic() || cNode.getProperty(fNode.getName()) != null) continue;
            result.add(fNode);
        }
        return result;
    }

    public static List<FieldNode> getSuperPropertyFields(ClassNode cNode) {
        List<Object> result = cNode == ClassHelper.OBJECT_TYPE ? new ArrayList() : AbstractASTTransformUtil.getSuperPropertyFields(cNode.getSuperClass());
        for (PropertyNode pNode : cNode.getProperties()) {
            if (pNode.isStatic()) continue;
            result.add(pNode.getField());
        }
        return result;
    }

    public static List<FieldNode> getSuperNonPropertyFields(ClassNode cNode) {
        List<Object> result = cNode == ClassHelper.OBJECT_TYPE ? new ArrayList() : AbstractASTTransformUtil.getSuperNonPropertyFields(cNode.getSuperClass());
        for (FieldNode fNode : cNode.getFields()) {
            if (fNode.isStatic() || cNode.getProperty(fNode.getName()) != null) continue;
            result.add(fNode);
        }
        return result;
    }

    public static Statement assignStatement(Expression fieldExpr, Expression value) {
        return new ExpressionStatement(AbstractASTTransformUtil.assignExpr(fieldExpr, value));
    }

    private static Expression assignExpr(Expression expression, Expression value) {
        return new BinaryExpression(expression, ASSIGN, value);
    }

    public static ExpressionStatement declStatement(Expression result, Expression init) {
        return new ExpressionStatement(new DeclarationExpression(result, ASSIGN, init));
    }

    public static BooleanExpression isInstanceOf(Expression objectExpression, ClassNode cNode) {
        return new BooleanExpression(new BinaryExpression(objectExpression, INSTANCEOF, new ClassExpression(cNode)));
    }

    public static BooleanExpression equalsNullExpr(Expression argExpr) {
        return new BooleanExpression(new BinaryExpression(argExpr, COMPARE_EQUAL, new ConstantExpression(null)));
    }

    public static BooleanExpression notNullExpr(Expression argExpr) {
        return new BooleanExpression(new BinaryExpression(argExpr, COMPARE_NOT_EQUAL, new ConstantExpression(null)));
    }

    public static BooleanExpression isZeroExpr(Expression expr) {
        return new BooleanExpression(new BinaryExpression(expr, COMPARE_EQUAL, new ConstantExpression(0)));
    }

    private static BooleanExpression notEqualsFieldExpr(FieldNode fNode, Expression other) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        PropertyExpression otherExpr = new PropertyExpression(other, fNode.getName());
        return new BooleanExpression(new BinaryExpression(fieldExpr, COMPARE_NOT_EQUAL, otherExpr));
    }

    public static BooleanExpression differentFieldExpr(FieldNode fNode, Expression other) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        PropertyExpression otherExpr = new PropertyExpression(other, fNode.getName());
        return AbstractASTTransformUtil.differentExpr(fieldExpr, otherExpr);
    }

    private static BooleanExpression notEqualsPropertyExpr(PropertyNode pNode, Expression other) {
        String getterName = "get" + Verifier.capitalize(pNode.getName());
        MethodCallExpression selfGetter = new MethodCallExpression((Expression)new VariableExpression("this"), getterName, MethodCallExpression.NO_ARGUMENTS);
        MethodCallExpression otherGetter = new MethodCallExpression(other, getterName, MethodCallExpression.NO_ARGUMENTS);
        return new BooleanExpression(new BinaryExpression(selfGetter, COMPARE_NOT_EQUAL, otherGetter));
    }

    public static BooleanExpression differentPropertyExpr(PropertyNode pNode, Expression other) {
        String getterName = "get" + Verifier.capitalize(pNode.getName());
        MethodCallExpression selfGetter = new MethodCallExpression((Expression)new VariableExpression("this"), getterName, MethodCallExpression.NO_ARGUMENTS);
        MethodCallExpression otherGetter = new MethodCallExpression(other, getterName, MethodCallExpression.NO_ARGUMENTS);
        return AbstractASTTransformUtil.differentExpr(selfGetter, otherGetter);
    }

    public static BooleanExpression identicalExpr(Expression self, Expression other) {
        return new BooleanExpression(new MethodCallExpression(self, "is", (Expression)new ArgumentListExpression(other)));
    }

    public static BooleanExpression differentExpr(Expression self, Expression other) {
        return new NotExpression(new BooleanExpression(new MethodCallExpression(self, "is", (Expression)new ArgumentListExpression(other))));
    }

    private static BooleanExpression notEqualClasses(ClassNode cNode, Expression other) {
        return new BooleanExpression(new BinaryExpression(new ClassExpression(cNode), COMPARE_NOT_EQUAL, new MethodCallExpression(other, "getClass", MethodCallExpression.NO_ARGUMENTS)));
    }

    public static BooleanExpression isInstanceof(ClassNode cNode, Expression other) {
        return new BooleanExpression(new BinaryExpression(other, INSTANCEOF, new ClassExpression(cNode)));
    }

    public static boolean isOrImplements(ClassNode fieldType, ClassNode interfaceType) {
        return fieldType.equals(interfaceType) || fieldType.implementsInterface(interfaceType);
    }

    public static BooleanExpression isTrueExpr(Expression argExpr) {
        return new BooleanExpression(new BinaryExpression(argExpr, COMPARE_EQUAL, new ConstantExpression(Boolean.TRUE)));
    }

    public static BooleanExpression isOneExpr(Expression expr) {
        return new BooleanExpression(new BinaryExpression(expr, COMPARE_EQUAL, new ConstantExpression(1)));
    }

    public static Statement safeExpression(Expression fieldExpr, Expression expression) {
        return new IfStatement(AbstractASTTransformUtil.equalsNullExpr(fieldExpr), new ExpressionStatement(fieldExpr), new ExpressionStatement(expression));
    }

    public static Statement createConstructorStatementDefault(FieldNode fNode) {
        String name = fNode.getName();
        PropertyExpression fieldExpr = new PropertyExpression((Expression)new VariableExpression("this"), name);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = new ConstantExpression(null);
        }
        Expression value = AbstractASTTransformUtil.findArg(name);
        return new IfStatement(AbstractASTTransformUtil.equalsNullExpr(value), new IfStatement(AbstractASTTransformUtil.equalsNullExpr(initExpr), EmptyStatement.INSTANCE, AbstractASTTransformUtil.assignStatement(fieldExpr, initExpr)), AbstractASTTransformUtil.assignStatement(fieldExpr, value));
    }

    public static Expression findArg(String argName) {
        return new PropertyExpression((Expression)new VariableExpression("args"), argName);
    }
}

