/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractASTTransformation
implements Opcodes,
ASTTransformation {
    private SourceUnit sourceUnit;

    protected void init(ASTNode[] nodes, SourceUnit sourceUnit) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
        this.sourceUnit = sourceUnit;
    }

    protected boolean memberHasValue(AnnotationNode node, String name, Object value) {
        Expression member = node.getMember(name);
        return member != null && member instanceof ConstantExpression && ((ConstantExpression)member).getValue().equals(value);
    }

    protected Object getMemberValue(AnnotationNode node, String name) {
        Expression member = node.getMember(name);
        if (member != null && member instanceof ConstantExpression) {
            return ((ConstantExpression)member).getValue();
        }
        return null;
    }

    protected String getMemberStringValue(AnnotationNode node, String name) {
        Object result;
        Expression member = node.getMember(name);
        if (member != null && member instanceof ConstantExpression && (result = ((ConstantExpression)member).getValue()) != null) {
            return result.toString();
        }
        return null;
    }

    protected List<String> getMemberList(AnnotationNode anno, String name) {
        ArrayList<String> list;
        Expression expr = anno.getMember(name);
        if (expr != null && expr instanceof ListExpression) {
            list = new ArrayList();
            ListExpression listExpression = (ListExpression)expr;
            for (Expression itemExpr : listExpression.getExpressions()) {
                Object value;
                if (itemExpr == null || !(itemExpr instanceof ConstantExpression) || (value = ((ConstantExpression)itemExpr).getValue()) == null) continue;
                list.add(value.toString());
            }
        } else {
            list = this.tokenize(this.getMemberStringValue(anno, name));
        }
        return list;
    }

    protected void addError(String msg, ASTNode expr) {
        int line = expr.getLineNumber();
        int col = expr.getColumnNumber();
        this.sourceUnit.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', line, col), this.sourceUnit));
    }

    protected void checkNotInterface(ClassNode cNode, String annotationName) {
        if (cNode.isInterface()) {
            this.addError("Error processing interface '" + cNode.getName() + "'. " + annotationName + " not allowed for interfaces.", cNode);
        }
    }

    protected boolean hasAnnotation(ClassNode cNode, ClassNode annotation) {
        List<AnnotationNode> annots = cNode.getAnnotations(annotation);
        return annots != null && annots.size() > 0;
    }

    protected List<String> tokenize(String rawExcludes) {
        return rawExcludes == null ? new ArrayList() : StringGroovyMethods.tokenize(rawExcludes, ", ");
    }
}

