/*
 * Decompiled with CFR 0.152.
 */
package org.castor.transactionmanager;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.transactionmanager.TransactionManagerAcquireException;
import org.castor.transactionmanager.TransactionManagerFactory;

public final class JNDIENCTransactionManagerFactory
implements TransactionManagerFactory {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$transactionmanager$JNDIENCTransactionManagerFactory == null ? (class$org$castor$transactionmanager$JNDIENCTransactionManagerFactory = JNDIENCTransactionManagerFactory.class$("org.castor.transactionmanager.JNDIENCTransactionManagerFactory")) : class$org$castor$transactionmanager$JNDIENCTransactionManagerFactory));
    public static final String TRANSACTION_MANAGER_NAME = "java:comp/TransactionManager";
    public static final String NAME = "jndi";
    static /* synthetic */ Class class$org$castor$transactionmanager$JNDIENCTransactionManagerFactory;

    public String getName() {
        return NAME;
    }

    public TransactionManager getTransactionManager(Properties properties) throws TransactionManagerAcquireException {
        String jndiENC = properties.getProperty("jndiEnc", TRANSACTION_MANAGER_NAME);
        Object found = null;
        TransactionManager transactionManager = null;
        try {
            found = new InitialContext().lookup(jndiENC);
            transactionManager = (TransactionManager)found;
        }
        catch (ClassCastException ex) {
            String msg = "Problem casting instance of " + found.getClass().getName() + " to javax.transaction.TransactionManager.";
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg, ex);
        }
        catch (Exception ex) {
            String msg = "Unable to acquire instance of javax.transaction.TransactionManager: " + jndiENC;
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg, ex);
        }
        if (transactionManager == null) {
            String msg = "Unable to acquire instance of javax.transaction.TransactionManager: " + jndiENC;
            LOG.error((Object)msg);
            throw new TransactionManagerAcquireException(msg);
        }
        return transactionManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

