/*
 * Decompiled with CFR 0.152.
 */
package org.castor.tools.log4j;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.castor.tools.log4j.LogEntry;
import org.castor.tools.log4j.LogExceptionEntry;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.JDOManager;
import org.exolab.castor.jdo.Query;
import org.exolab.castor.jdo.QueryResults;

public final class CastorAppender
extends AppenderSkeleton {
    private static final int COLUMNWIDTHCLASS = 100;
    private static final int COLUMNWIDTHTHREAD = 100;
    private static final int COLUMNWIDTHMESSAGE = 1000;
    private static final int COLUMNWIDTHSTACKTRACE = 20000;
    private static final boolean DUPLICATECOUNT = false;
    private static List _elements = new ArrayList();
    private int _bufferSize = 1;
    private ArrayList _buffer;
    private ArrayList _removes;
    private Database _database;
    private Query _qry;
    private String _databaseName;
    private int _columnWidthClass = 100;
    private int _columnWidthThread = 100;
    private int _columnWidthMessage = 1000;
    private int _columnWidthStackTrace = 20000;
    private boolean _duplicateCount = false;
    static /* synthetic */ Class class$org$castor$tools$log4j$LogEntry;

    private static synchronized void addAppender(CastorAppender appender) {
        _elements.add(appender);
    }

    private static synchronized void removeAppender(CastorAppender appender) {
        _elements.remove((Object)appender);
    }

    private static synchronized CastorAppender[] getAppenders() {
        CastorAppender[] appenders = new CastorAppender[_elements.size()];
        return _elements.toArray(appenders);
    }

    public static void flush() {
        CastorAppender[] appenders = CastorAppender.getAppenders();
        if (appenders.length > 0) {
            for (int i = 0; i < appenders.length; ++i) {
                appenders[i].flushBuffer();
            }
        }
    }

    public CastorAppender() {
        CastorAppender.addAppender(this);
        this._database = null;
        this._buffer = new ArrayList(this._bufferSize);
        this._removes = new ArrayList(this._bufferSize);
    }

    public void finalize() {
        this.close();
    }

    public void close() {
        this.flushBuffer();
        if (this._database != null) {
            try {
                this._qry.close();
                this._database.close();
            }
            catch (Exception e) {
                this.errorHandler.error("Error closing database.", e, 3);
            }
        }
        this.closed = true;
        CastorAppender.removeAppender(this);
    }

    public synchronized void append(LoggingEvent event) {
        this._buffer.add(event);
        if (this._buffer.size() >= this._bufferSize) {
            this.flushBuffer();
        }
    }

    private synchronized void flushBuffer() {
        this._removes.ensureCapacity(this._buffer.size());
        Database db = this.getDatabase();
        try {
            Iterator i = this._buffer.iterator();
            while (i.hasNext()) {
                LoggingEvent logEvent = (LoggingEvent)i.next();
                this.execute(logEvent);
                this._removes.add(logEvent);
            }
            db.commit();
            this._buffer.removeAll(this._removes);
            this._removes.clear();
        }
        catch (Exception e) {
            this.errorHandler.error("Error flush buffer.", e, 0);
        }
    }

    private Database getDatabase() {
        if (this._database == null) {
            try {
                this._database = JDOManager.createInstance(this._databaseName).getDatabase();
                this._database.begin();
                String oql = "select o from " + (class$org$castor$tools$log4j$LogEntry == null ? (class$org$castor$tools$log4j$LogEntry = CastorAppender.class$("org.castor.tools.log4j.LogEntry")) : class$org$castor$tools$log4j$LogEntry).getName() + " o where o.className = $1 and" + " o.level = $2 and" + " o.message = $3";
                this._qry = this._database.getOQLQuery(oql);
            }
            catch (Exception e) {
                this.errorHandler.error("Error get database.", e, 0);
            }
        } else {
            try {
                this._database.begin();
            }
            catch (Exception e) {
                this.errorHandler.error("Cannot begin a transaction.", e, 0);
            }
        }
        return this._database;
    }

    private void execute(LoggingEvent event) {
        boolean hasException;
        LogEntry entry;
        if (event.getMessage() instanceof LogEntry) {
            entry = (LogEntry)event.getMessage();
        } else if (event.getMessage() != null) {
            String message = event.getMessage().toString();
            message = this.clipLength(message, this._columnWidthMessage);
            entry = new LogEntry(message);
        } else {
            entry = new LogEntry();
        }
        String clazz = event.getLoggerName();
        clazz = this.clipLength(clazz, this._columnWidthClass);
        entry.setClassName(clazz);
        String thread = event.getThreadName();
        thread = this.clipLength(thread, this._columnWidthThread);
        entry.setThread(thread);
        entry.setLevel(event.getLevel().toString());
        entry.setTimestamp(new Date(event.timeStamp));
        boolean bl = hasException = event.getThrowableInformation() != null;
        if (hasException && this._columnWidthStackTrace > 0) {
            LogExceptionEntry exceptionEntry = new LogExceptionEntry();
            String temp = "";
            String[] stackTrace = event.getThrowableStrRep();
            int stackSize = stackTrace.length;
            for (int i = 0; i < stackSize; ++i) {
                temp = temp.concat(stackTrace[i] + "\n");
            }
            temp = this.clipLength(temp, this._columnWidthStackTrace);
            exceptionEntry.setStackTrace(temp);
            exceptionEntry.setEntry(entry);
            entry.setException(exceptionEntry);
        }
        try {
            if (!hasException && this._duplicateCount) {
                this._qry.bind(entry.getClassName());
                this._qry.bind(entry.getLevel());
                this._qry.bind(entry.getMessage());
                QueryResults rst = this._qry.execute();
                if (rst.hasMore()) {
                    LogEntry x = (LogEntry)rst.next();
                    x.setTimestamp(entry.getTimestamp());
                    x.setThread(entry.getThread());
                    x.setCount(new Integer(x.getCount() + 1));
                } else {
                    entry.setCount(new Integer(1));
                    this._database.create(entry);
                }
                rst.close();
            } else {
                entry.setCount(new Integer(1));
                this._database.create(entry);
            }
        }
        catch (Exception e) {
            this.errorHandler.error("Cannot save the object.", e, 2);
        }
    }

    private String clipLength(String value, int maxLength) {
        if (value.length() > maxLength) {
            return value.substring(0, maxLength);
        }
        return value;
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setBufferSize(int newBufferSize) {
        this._bufferSize = newBufferSize;
        this._buffer.ensureCapacity(this._bufferSize);
        this._removes.ensureCapacity(this._bufferSize);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setDatabaseName(String name) {
        this._databaseName = name;
    }

    public String getDatabaseName() {
        return this._databaseName;
    }

    public void setColumnWidthClass(int columWidth) {
        this._columnWidthClass = columWidth;
    }

    public int getColumnWidthClass() {
        return this._columnWidthClass;
    }

    public void setColumnWidthThread(int columWidth) {
        this._columnWidthThread = columWidth;
    }

    public int getColumnWidthThread() {
        return this._columnWidthThread;
    }

    public void setColumnWidthMessage(int columWidth) {
        this._columnWidthMessage = columWidth;
    }

    public int getColumnWidthMessage() {
        return this._columnWidthMessage;
    }

    public void setColumnWidthStackTrace(int columWidth) {
        this._columnWidthStackTrace = columWidth;
    }

    public int getColumnWidthStackTrace() {
        return this._columnWidthStackTrace;
    }

    public void setDuplicateCount(String duplicateCount) {
        String temp = duplicateCount.toLowerCase();
        this._duplicateCount = "true".equals(temp);
    }

    public String getDuplicateCount() {
        return new Boolean(this._duplicateCount).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

