/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.recovery;

import bitronix.tm.BitronixXid;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.journal.TransactionLogRecord;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.recovery.RecoveryHelper;
import bitronix.tm.resource.common.XAResourceProducer;
import bitronix.tm.utils.Decoder;
import bitronix.tm.utils.Uid;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalRecoverer {
    private static final Logger log = LoggerFactory.getLogger(IncrementalRecoverer.class);

    public static void recover(XAResourceProducer xaResourceProducer) throws RecoveryException {
        String uniqueName = xaResourceProducer.getUniqueName();
        if (log.isDebugEnabled()) {
            log.debug("start of incremental recovery on resource " + uniqueName);
        }
        try {
            XAResourceHolderState xaResourceHolderState = xaResourceProducer.startRecovery();
            boolean success = true;
            Set<BitronixXid> xids = RecoveryHelper.recover(xaResourceHolderState);
            if (log.isDebugEnabled()) {
                log.debug(xids.size() + " dangling transaction(s) found on resource");
            }
            Map<Uid, TransactionLogRecord> danglingRecords = TransactionManagerServices.getJournal().collectDanglingRecords();
            if (log.isDebugEnabled()) {
                log.debug(danglingRecords.size() + " dangling transaction(s) found in journal");
            }
            int commitCount = 0;
            int rollbackCount = 0;
            for (BitronixXid xid : xids) {
                Uid gtrid = xid.getGlobalTransactionIdUid();
                TransactionLogRecord tlog = danglingRecords.get(gtrid);
                if (tlog != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("committing " + xid);
                    }
                    success &= RecoveryHelper.commit(xaResourceHolderState, xid);
                    IncrementalRecoverer.updateJournal(xid.getGlobalTransactionIdUid(), uniqueName, 3);
                    ++commitCount;
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("rolling back " + xid);
                }
                success &= RecoveryHelper.rollback(xaResourceHolderState, xid);
                IncrementalRecoverer.updateJournal(xid.getGlobalTransactionIdUid(), uniqueName, 4);
                ++rollbackCount;
            }
            if (!success) {
                throw new RecoveryException("error recovering resource '" + uniqueName + "' due to an incompatible heuristic decision");
            }
            xaResourceProducer.setFailed(false);
            log.info("incremental recovery committed " + commitCount + " dangling transaction(s) and rolled back " + rollbackCount + " aborted transaction(s) on resource [" + uniqueName + "]" + (TransactionManagerServices.getConfiguration().isCurrentNodeOnlyRecovery() ? " (restricted to serverId '" + TransactionManagerServices.getConfiguration().getServerId() + "')" : ""));
        }
        catch (XAException ex) {
            xaResourceProducer.setFailed(true);
            throw new RecoveryException("failed recovering resource " + uniqueName, ex);
        }
        catch (IOException ex) {
            xaResourceProducer.setFailed(true);
            throw new RecoveryException("failed recovering resource " + uniqueName, ex);
        }
        catch (RuntimeException ex) {
            xaResourceProducer.setFailed(true);
            throw new RecoveryException("failed recovering resource " + uniqueName, ex);
        }
        catch (RecoveryException ex) {
            xaResourceProducer.setFailed(true);
            throw ex;
        }
        finally {
            xaResourceProducer.endRecovery();
            if (log.isDebugEnabled()) {
                log.debug("end of incremental recovery on resource " + uniqueName);
            }
        }
    }

    private static void updateJournal(Uid gtrid, String uniqueName, int status) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("updating journal, adding " + Decoder.decodeStatus(status) + " entry for [" + uniqueName + "] on GTRID [" + gtrid + "]");
        }
        HashSet<String> participatingUniqueNames = new HashSet<String>();
        participatingUniqueNames.add(uniqueName);
        TransactionManagerServices.getJournal().log(status, gtrid, participatingUniqueNames);
    }
}

