/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import org.calrissian.mango.domain.ip.IPv4;
import org.calrissian.mango.types.encoders.AbstractIPv4Encoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class IPv4Encoder
extends AbstractIPv4Encoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(IPv4 value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        return EncodingUtils.encodeUInt((int)value.getValue());
    }

    @Override
    public IPv4 decode(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        Preconditions.checkArgument((value.length() == 8 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        return new IPv4(EncodingUtils.fromHex(value));
    }
}

