/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.types.encoders.lexi;

import com.google.common.base.Preconditions;
import org.calrissian.mango.types.encoders.AbstractDoubleEncoder;
import org.calrissian.mango.types.encoders.lexi.EncodingUtils;

public class DoubleReverseEncoder
extends AbstractDoubleEncoder<String> {
    private static final long serialVersionUID = 1L;

    @Override
    public String encode(Double value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        return EncodingUtils.encodeULong(EncodingUtils.normalizeDouble(value) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public Double decode(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed");
        Preconditions.checkArgument((value.length() == 16 ? 1 : 0) != 0, (Object)"The value is not a valid encoding");
        return EncodingUtils.denormalizeDouble(EncodingUtils.fromHex(value) ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

