/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DeletingFileInputStream
extends FileInputStream {
    private final boolean deleteOnClose;
    private final File file;

    public DeletingFileInputStream(String name, boolean deleteOnClose) throws FileNotFoundException {
        this(name != null ? new File(name) : null, deleteOnClose);
    }

    public DeletingFileInputStream(File file, boolean deleteOnClose) throws FileNotFoundException {
        super(file);
        this.file = file;
        this.deleteOnClose = deleteOnClose;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.deleteOnClose && this.file != null) {
            this.file.delete();
        }
    }
}

