/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.domain.entity;

import com.google.common.base.Preconditions;
import org.calrissian.mango.domain.Identifiable;
import org.calrissian.mango.domain.entity.Entity;

public class EntityIndex
implements Identifiable {
    protected String type;
    protected String id;

    public EntityIndex(String type, String id) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)id);
        this.type = type;
        this.id = id;
    }

    public EntityIndex(Entity entity) {
        this(entity.getType(), entity.getId());
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityIndex that = (EntityIndex)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EntityIndex{type='" + this.type + '\'' + ", id='" + this.id + '\'' + '}';
    }
}

