/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core.operation;

import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.operation.ExaminationEntry;
import org.cache2k.core.operation.LoadedEntry;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.Progress;
import org.cache2k.processor.MutableCacheEntry;

class MutableEntryOnProgress<K, V>
implements MutableCacheEntry<K, V> {
    private ExaminationEntry<K, V> entry;
    private Progress<K, V, ?> progress;
    private boolean originalExists = false;
    private boolean mutate = false;
    private boolean remove = false;
    private boolean exists = false;
    private V value = null;
    private boolean readThrough = false;
    private boolean customExpiry = false;
    private long expiry;

    public MutableEntryOnProgress(Progress<K, V, ?> _progress, ExaminationEntry<K, V> _entry, boolean _readThrough) {
        this.readThrough = _readThrough;
        this.entry = _entry;
        this.progress = _progress;
        if (_progress.isPresentOrMiss()) {
            this.value = this.entry.getValueOrException();
            this.exists = true;
            this.originalExists = true;
        }
    }

    public boolean exists() {
        return this.exists;
    }

    public MutableCacheEntry<K, V> setValue(V v) {
        this.mutate = true;
        this.exists = true;
        this.remove = false;
        this.value = v;
        return this;
    }

    public MutableCacheEntry<K, V> setException(Throwable ex) {
        this.mutate = true;
        this.exists = true;
        this.remove = false;
        this.value = new ExceptionWrapper(ex);
        return this;
    }

    public MutableCacheEntry<K, V> setExpiry(long t) {
        this.customExpiry = true;
        this.expiry = t;
        return this;
    }

    public MutableCacheEntry<K, V> remove() {
        if (this.mutate && !this.originalExists) {
            this.mutate = false;
        } else {
            this.remove = true;
            this.mutate = true;
        }
        this.exists = false;
        this.value = null;
        return this;
    }

    public K getKey() {
        return this.entry.getKey();
    }

    public V getValue() {
        if (!this.exists && !this.mutate && this.readThrough) {
            throw new Operations.NeedsLoadRestartException();
        }
        if (this.value instanceof ExceptionWrapper) {
            throw this.progress.propagateException(this.entry.getKey(), (ExceptionWrapper)this.value);
        }
        return this.value;
    }

    public V getOldValue() {
        if (!this.originalExists || this.entry instanceof LoadedEntry) {
            return null;
        }
        V _value = this.entry.getValueOrException();
        if (_value instanceof ExceptionWrapper) {
            throw this.progress.propagateException(this.entry.getKey(), (ExceptionWrapper)_value);
        }
        return _value;
    }

    public boolean wasExisting() {
        return this.originalExists && !(this.entry instanceof LoadedEntry);
    }

    public Throwable getException() {
        if (!this.exists && !this.mutate && this.readThrough) {
            throw new Operations.NeedsLoadRestartException();
        }
        if (this.value instanceof ExceptionWrapper) {
            return ((ExceptionWrapper)this.value).getException();
        }
        return null;
    }

    public long getLastModification() {
        return this.entry.getLastModification();
    }

    public void sendMutationCommandIfNeeded() {
        if (this.mutate) {
            if (this.remove) {
                this.progress.remove();
                return;
            }
            if (this.customExpiry) {
                this.progress.putAndSetExpiry(this.value, this.expiry);
                return;
            }
            this.progress.put(this.value);
            return;
        }
        if (this.customExpiry) {
            this.progress.expire(this.expiry);
        }
    }
}

