/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.core.Entry;
import org.cache2k.integration.ExceptionInformation;

public class ExceptionWrapper<K>
implements ExceptionInformation {
    private Throwable exception;
    private long loadTime;
    private long until;
    private int count;
    private long since;
    private K key;

    public ExceptionWrapper(Throwable ex) {
        this.loadTime = System.currentTimeMillis();
        this.exception = ex;
    }

    public ExceptionWrapper(K _key, Throwable _exception, long _loadTime, Entry e) {
        Object _oldValue = e.getValueOrException();
        ExceptionInformation _recentExceptionInfo = _oldValue instanceof ExceptionWrapper ? (ExceptionInformation)_oldValue : e.getSuppressedLoadExceptionInformation();
        this.init(_key, _exception, _loadTime, _recentExceptionInfo);
    }

    public ExceptionWrapper(K _key, Throwable _exception, long _loadTime, ExceptionInformation w) {
        this.init(_key, _exception, _loadTime, w);
    }

    private void init(K _key, Throwable _exception, long _loadTime, ExceptionInformation w) {
        this.exception = _exception;
        this.key = _key;
        this.loadTime = _loadTime;
        if (w != null) {
            this.since = w.getSinceTime();
            this.count = w.getRetryCount() + 1;
        } else {
            this.since = this.loadTime;
        }
    }

    public void setUntil(long _until) {
        this.until = _until;
    }

    public K getKey() {
        return this.key;
    }

    public Throwable getException() {
        return this.exception;
    }

    public long getUntil() {
        return this.until;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public int getRetryCount() {
        return this.count;
    }

    public long getSinceTime() {
        return this.since;
    }

    public String toString() {
        return "ExceptionWrapper{" + this.exception.toString() + "}";
    }
}

