/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.gui.image.ScaleOptions;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ImagePanel
extends JPanel {
    protected BufferedImage img;
    protected ScaleOptions scaling = ScaleOptions.DOWN;

    public ImagePanel(BufferedImage img) {
        this(img, ScaleOptions.NONE);
    }

    public ImagePanel(BufferedImage img, ScaleOptions scaling) {
        this.img = img;
        this.scaling = scaling;
        this.autoSetPreferredSize();
    }

    public ImagePanel(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    public ImagePanel() {
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        BufferedImage img = this.img;
        if (img != null) {
            if (this.scaling != ScaleOptions.NONE) {
                double ratioW = (double)this.getWidth() / (double)img.getWidth();
                double ratioH = (double)this.getHeight() / (double)img.getHeight();
                double ratio = Math.min(ratioW, ratioH);
                if (this.scaling == ScaleOptions.DOWN && ratio >= 1.0) {
                    ratio = 1.0;
                }
                if (ratio == 1.0) {
                    g.drawImage(img, 0, 0, this);
                } else {
                    AffineTransform tran = AffineTransform.getScaleInstance(ratio, ratio);
                    g2.drawImage(img, tran, null);
                }
            } else {
                g2.drawImage((Image)img, 0, 0, this);
            }
        }
    }

    public void setBufferedImage(BufferedImage image) {
        this.img = image;
        this.repaint();
    }

    public void setBufferedImageSafe(final BufferedImage image) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImagePanel.this.setBufferedImage(image);
            }
        });
    }

    public BufferedImage getImage() {
        return this.img;
    }

    public void setScaling(ScaleOptions scaling) {
        this.scaling = scaling;
    }

    public void autoSetPreferredSize() {
        this.setPreferredSize(new Dimension(this.img.getWidth(), this.img.getHeight()));
    }
}

