/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.fiducial;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.WorldToCameraToPixel;
import boofcv.struct.calib.IntrinsicParameters;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class VisualizeFiducial {
    private static final Font font = new Font("Serif", 1, 24);

    public static void drawLabelCenter(Se3_F64 targetToCamera, IntrinsicParameters intrinsic, String label, Graphics2D g2) {
        Point2D_F64 p = new Point2D_F64();
        Point3D_F64 c = new Point3D_F64();
        WorldToCameraToPixel worldToPixel = PerspectiveOps.createWorldToPixel((IntrinsicParameters)intrinsic, (Se3_F64)targetToCamera);
        worldToPixel.transform(c, p);
        FontMetrics metrics = g2.getFontMetrics(font);
        Rectangle2D r = metrics.getStringBounds(label, null);
        g2.setColor(Color.ORANGE);
        g2.setFont(font);
        g2.drawString(label, (float)(p.x - r.getWidth() / 2.0), (float)(p.y + r.getHeight() / 2.0));
    }

    public static void drawCube(Se3_F64 targetToCamera, IntrinsicParameters intrinsic, double width, int lineThickness, Graphics2D g2) {
        double r;
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double h = r = width / 2.0;
        Point3D_F64[] corners = new Point3D_F64[]{new Point3D_F64(-r, -r, 0.0), new Point3D_F64(r, -r, 0.0), new Point3D_F64(r, r, 0.0), new Point3D_F64(-r, r, 0.0), new Point3D_F64(-r, -r, h), new Point3D_F64(r, -r, h), new Point3D_F64(r, r, h), new Point3D_F64(-r, r, h)};
        Point2D_F64[] pixel = new Point2D_F64[8];
        Point2D_F64 p = new Point2D_F64();
        WorldToCameraToPixel transform = PerspectiveOps.createWorldToPixel((IntrinsicParameters)intrinsic, (Se3_F64)targetToCamera);
        for (int i = 0; i < 8; ++i) {
            if (!transform.transform(corners[i], p)) {
                throw new RuntimeException("Crap");
            }
            pixel[i] = p.copy();
        }
        Line2D.Double l = new Line2D.Double();
        g2.setStroke(new BasicStroke(lineThickness));
        g2.setColor(Color.RED);
        VisualizeFiducial.drawLine(g2, l, pixel[0].x, pixel[0].y, pixel[1].x, pixel[1].y);
        VisualizeFiducial.drawLine(g2, l, pixel[1].x, pixel[1].y, pixel[2].x, pixel[2].y);
        VisualizeFiducial.drawLine(g2, l, pixel[2].x, pixel[2].y, pixel[3].x, pixel[3].y);
        VisualizeFiducial.drawLine(g2, l, pixel[3].x, pixel[3].y, pixel[0].x, pixel[0].y);
        g2.setColor(Color.BLACK);
        VisualizeFiducial.drawLine(g2, l, pixel[0].x, pixel[0].y, pixel[4].x, pixel[4].y);
        VisualizeFiducial.drawLine(g2, l, pixel[1].x, pixel[1].y, pixel[5].x, pixel[5].y);
        VisualizeFiducial.drawLine(g2, l, pixel[2].x, pixel[2].y, pixel[6].x, pixel[6].y);
        VisualizeFiducial.drawLine(g2, l, pixel[3].x, pixel[3].y, pixel[7].x, pixel[7].y);
        g2.setColor(new Color(0, 255, 0, 255));
        VisualizeFiducial.drawLine(g2, l, pixel[4].x, pixel[4].y, pixel[5].x, pixel[5].y);
        g2.setColor(new Color(192, 16, 192, 255));
        VisualizeFiducial.drawLine(g2, l, pixel[5].x, pixel[5].y, pixel[6].x, pixel[6].y);
        g2.setColor(new Color(0, 160, 192, 255));
        VisualizeFiducial.drawLine(g2, l, pixel[6].x, pixel[6].y, pixel[7].x, pixel[7].y);
        g2.setColor(Color.BLUE);
        VisualizeFiducial.drawLine(g2, l, pixel[7].x, pixel[7].y, pixel[4].x, pixel[4].y);
    }

    public static void drawLine(Graphics2D g2, Line2D.Double line, double x0, double y0, double x1, double y1) {
        line.setLine(x0, y0, x1, y1);
        g2.draw(line);
    }

    public static void drawChessboard(Graphics2D g2, WorldToCameraToPixel fiducialToPixel, int numRows, int numCols, double squareWidth) {
        Point3D_F64 fidPt = new Point3D_F64();
        Point2D_F64 pixel0 = new Point2D_F64();
        Point2D_F64 pixel1 = new Point2D_F64();
        Point2D_F64 pixel2 = new Point2D_F64();
        Point2D_F64 pixel3 = new Point2D_F64();
        Line2D.Double l = new Line2D.Double();
        int[] polyX = new int[4];
        int[] polyY = new int[4];
        int alpha = 100;
        Color red = new Color(255, 0, 0, alpha);
        Color black = new Color(0, 0, 0, alpha);
        for (int row = 0; row < numRows; ++row) {
            double y0 = (double)(-numRows) * squareWidth / 2.0 + (double)row * squareWidth;
            for (int col = row % 2; col < numCols; col += 2) {
                double x0 = (double)(-numCols) * squareWidth / 2.0 + (double)col * squareWidth;
                fidPt.set(x0, y0, 0.0);
                fiducialToPixel.transform(fidPt, pixel0);
                fidPt.set(x0 + squareWidth, y0, 0.0);
                fiducialToPixel.transform(fidPt, pixel1);
                fidPt.set(x0 + squareWidth, y0 + squareWidth, 0.0);
                fiducialToPixel.transform(fidPt, pixel2);
                fidPt.set(x0, y0 + squareWidth, 0.0);
                fiducialToPixel.transform(fidPt, pixel3);
                polyX[0] = (int)(pixel0.x + 0.5);
                polyX[1] = (int)(pixel1.x + 0.5);
                polyX[2] = (int)(pixel2.x + 0.5);
                polyX[3] = (int)(pixel3.x + 0.5);
                polyY[0] = (int)(pixel0.y + 0.5);
                polyY[1] = (int)(pixel1.y + 0.5);
                polyY[2] = (int)(pixel2.y + 0.5);
                polyY[3] = (int)(pixel3.y + 0.5);
                g2.setColor(black);
                g2.fillPolygon(polyX, polyY, 4);
                g2.setColor(red);
                VisualizeFiducial.drawLine(g2, l, pixel0.x, pixel0.y, pixel1.x, pixel1.y);
                VisualizeFiducial.drawLine(g2, l, pixel1.x, pixel1.y, pixel2.x, pixel2.y);
                VisualizeFiducial.drawLine(g2, l, pixel2.x, pixel2.y, pixel3.x, pixel3.y);
                VisualizeFiducial.drawLine(g2, l, pixel3.x, pixel3.y, pixel0.x, pixel0.y);
            }
        }
    }
}

