/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.core.image.border.BorderType;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PointTransform_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.ejml.data.DenseMatrix64F;

public class CalibratedImageGridPanel
extends JPanel {
    List<BufferedImage> images;
    int selectedImage;
    BufferedImage undistorted;
    boolean isUndistorted = false;
    List<CalibrationObservation> features = new ArrayList<CalibrationObservation>();
    List<ImageResults> results = new ArrayList<ImageResults>();
    Planar<GrayF32> origMS;
    Planar<GrayF32> correctedMS;
    boolean showPoints = true;
    boolean showErrors = true;
    boolean showUndistorted = false;
    boolean showAll = false;
    boolean showNumbers = true;
    ImageDistort<GrayF32, GrayF32> undoRadial;
    PointTransform_F32 remove_p_to_p;
    double errorScale;
    int lineY = -1;

    public void setDisplay(boolean showPoints, boolean showErrors, boolean showUndistorted, boolean showAll, boolean showNumbers, double errorScale) {
        this.showPoints = showPoints;
        this.showErrors = showErrors;
        this.showUndistorted = showUndistorted;
        this.showAll = showAll;
        this.showNumbers = showNumbers;
        this.errorScale = errorScale;
    }

    public void setSelected(int selected) {
        this.selectedImage = selected;
        this.isUndistorted = false;
        if (this.origMS == null) {
            BufferedImage image = this.images.get(selected);
            this.origMS = ConvertBufferedImage.convertFromMulti((BufferedImage)image, null, (boolean)true, GrayF32.class);
            this.correctedMS = ConvertBufferedImage.convertFromMulti((BufferedImage)image, null, (boolean)true, GrayF32.class);
            this.undistorted = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        }
    }

    public void setImages(List<BufferedImage> images) {
        this.images = images;
    }

    public void setResults(List<CalibrationObservation> features, List<ImageResults> results) {
        this.features = features;
        this.results = results;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.images == null || this.selectedImage >= this.images.size()) {
            return;
        }
        BufferedImage image = this.images.get(this.selectedImage);
        double scaleX = (double)this.getWidth() / (double)image.getWidth();
        double scaleY = (double)this.getHeight() / (double)image.getHeight();
        double scale = Math.min(1.0, Math.min(scaleX, scaleY));
        AffineTransform tranOrig = g2.getTransform();
        AffineTransform tran = g2.getTransform();
        tran.concatenate(AffineTransform.getScaleInstance(scale, scale));
        g2.setTransform(tran);
        if (this.showUndistorted) {
            if (this.undoRadial != null && !this.isUndistorted) {
                this.undoRadialDistortion(image);
                this.isUndistorted = true;
            }
            g2.drawImage((Image)this.undistorted, 0, 0, null);
        } else {
            g2.drawImage((Image)image, 0, 0, null);
        }
        g2.setTransform(tranOrig);
        if (this.features.size() > this.selectedImage) {
            this.drawFeatures(g2, scale);
        }
        if (this.lineY > -1) {
            g2.setColor(Color.RED);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine(0, this.lineY, this.getWidth(), this.lineY);
        }
    }

    private void undoRadialDistortion(BufferedImage image) {
        ConvertBufferedImage.convertFromMulti((BufferedImage)image, this.origMS, (boolean)true, GrayF32.class);
        for (int i = 0; i < this.origMS.getNumBands(); ++i) {
            GrayF32 in = (GrayF32)this.origMS.getBand(i);
            GrayF32 out = (GrayF32)this.correctedMS.getBand(i);
            this.undoRadial.apply((ImageBase)in, (ImageBase)out);
        }
        if (this.correctedMS.getNumBands() == 3) {
            ConvertBufferedImage.convertTo(this.correctedMS, (BufferedImage)this.undistorted, (boolean)true);
        } else if (this.correctedMS.getNumBands() == 1) {
            ConvertBufferedImage.convertTo((GrayF32)((GrayF32)this.correctedMS.getBand(0)), (BufferedImage)this.undistorted);
        } else {
            throw new RuntimeException("What kind of image has " + this.correctedMS.getNumBands() + "???");
        }
    }

    private void drawFeatures(Graphics2D g2, double scale) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        CalibrationObservation set = this.features.get(this.selectedImage);
        Point2D_F32 adj = new Point2D_F32();
        if (this.showPoints) {
            g2.setColor(Color.BLACK);
            g2.setStroke(new BasicStroke(3.0f));
            for (CalibrationObservation.Point p : set.points) {
                if (this.showUndistorted) {
                    this.remove_p_to_p.compute((float)p.pixel.x, (float)p.pixel.y, adj);
                } else {
                    adj.set((float)p.pixel.x, (float)p.pixel.y);
                }
                VisualizeFeatures.drawCross(g2, (double)adj.x * scale, (double)adj.y * scale, 4.0);
            }
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.RED);
            for (CalibrationObservation.Point p : set.points) {
                if (this.showUndistorted) {
                    this.remove_p_to_p.compute((float)p.pixel.x, (float)p.pixel.y, adj);
                } else {
                    adj.set((float)p.pixel.x, (float)p.pixel.y);
                }
                VisualizeFeatures.drawCross(g2, (double)adj.x * scale, (double)adj.y * scale, 4.0);
            }
        }
        if (this.showAll) {
            for (CalibrationObservation l : this.features) {
                for (CalibrationObservation.Point p : l.points) {
                    if (this.showUndistorted) {
                        this.remove_p_to_p.compute((float)p.pixel.x, (float)p.pixel.y, adj);
                    } else {
                        adj.set((float)p.pixel.x, (float)p.pixel.y);
                    }
                    VisualizeFeatures.drawPoint(g2, (double)adj.x * scale, (double)adj.y * scale, 2.0, Color.BLUE, false);
                }
            }
        }
        if (this.showNumbers) {
            if (this.showUndistorted) {
                CalibratedImageGridPanel.drawNumbers(g2, set, this.remove_p_to_p, scale);
            } else {
                CalibratedImageGridPanel.drawNumbers(g2, set, null, scale);
            }
        }
        if (this.showErrors && this.results != null && this.results.size() > this.selectedImage) {
            double r;
            int i;
            CalibrationObservation.Point p;
            ImageResults result = this.results.get(this.selectedImage);
            Stroke before = g2.getStroke();
            g2.setStroke(new BasicStroke(4.0f));
            g2.setColor(Color.BLACK);
            for (i = 0; i < set.size(); ++i) {
                p = set.get(i);
                if (this.showUndistorted) {
                    this.remove_p_to_p.compute((float)p.pixel.x, (float)p.pixel.y, adj);
                } else {
                    adj.set((float)p.pixel.x, (float)p.pixel.y);
                }
                r = this.errorScale * result.pointError[i];
                if (r < 1.0) continue;
                VisualizeFeatures.drawCircle(g2, (double)adj.x * scale, (double)adj.y * scale, r);
            }
            g2.setStroke(before);
            g2.setColor(Color.ORANGE);
            for (i = 0; i < set.size(); ++i) {
                p = set.get(i);
                if (this.showUndistorted) {
                    this.remove_p_to_p.compute((float)p.pixel.x, (float)p.pixel.y, adj);
                } else {
                    adj.set((float)p.pixel.x, (float)p.pixel.y);
                }
                r = this.errorScale * result.pointError[i];
                if (r < 1.0) continue;
                VisualizeFeatures.drawCircle(g2, (double)adj.x * scale, (double)adj.y * scale, r);
            }
        }
    }

    public void setDistorted(IntrinsicParameters param, DenseMatrix64F rect) {
        if (rect == null) {
            this.undoRadial = LensDistortionOps.imageRemoveDistortion((AdjustmentType)AdjustmentType.FULL_VIEW, (BorderType)BorderType.ZERO, (IntrinsicParameters)param, null, (ImageType)ImageType.single(GrayF32.class));
            this.remove_p_to_p = LensDistortionOps.transform_F32((AdjustmentType)AdjustmentType.FULL_VIEW, (IntrinsicParameters)param, null, (boolean)false);
        } else {
            this.undoRadial = RectifyImageOps.rectifyImage((IntrinsicParameters)param, (DenseMatrix64F)rect, (BorderType)BorderType.ZERO, (ImageType)ImageType.single(GrayF32.class));
            this.remove_p_to_p = RectifyImageOps.transformPixelToRect_F32((IntrinsicParameters)param, (DenseMatrix64F)rect);
        }
    }

    public void setLine(int y) {
        this.lineY = y;
    }

    public static void drawNumbers(Graphics2D g2, CalibrationObservation foundTarget, PointTransform_F32 transform, double scale) {
        Font regular = new Font("Serif", 0, 16);
        g2.setFont(regular);
        Point2D_F32 adj = new Point2D_F32();
        AffineTransform origTran = g2.getTransform();
        for (int i = 0; i < foundTarget.size(); ++i) {
            Point2D_F64 p = foundTarget.get((int)i).pixel;
            int gridIndex = foundTarget.get((int)i).index;
            if (transform != null) {
                transform.compute((float)p.x, (float)p.y, adj);
            } else {
                adj.set((float)p.x, (float)p.y);
            }
            String text = String.format("%2d", gridIndex);
            int x = (int)((double)adj.x * scale);
            int y = (int)((double)adj.y * scale);
            g2.setColor(Color.BLACK);
            g2.drawString(text, x - 1, y);
            g2.drawString(text, x + 1, y);
            g2.drawString(text, x, y - 1);
            g2.drawString(text, x, y + 1);
            g2.setTransform(origTran);
            g2.setColor(Color.GREEN);
            g2.drawString(text, x, y);
        }
    }
}

