/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.alg.feature.associate.AssociateStereo2D;
import boofcv.alg.geo.DistanceModelMonoPixels;
import boofcv.alg.geo.pose.PnPStereoDistanceReprojectionSq;
import boofcv.alg.geo.pose.RefinePnPStereo;
import boofcv.alg.sfm.d3.VisOdomQuadPnP;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.FastQueue;

public class WrapVisOdomQuadPnP<T extends ImageGray, TD extends TupleDesc>
implements StereoVisualOdometry<T>,
AccessPointTracks3D {
    VisOdomQuadPnP<T, TD> alg;
    RefinePnPStereo refine;
    AssociateStereo2D<TD> associateStereo;
    PnPStereoDistanceReprojectionSq distance;
    DistanceModelMonoPixels<Se3_F64, Point2D3D> distanceMono;
    Class<T> imageType;

    public WrapVisOdomQuadPnP(VisOdomQuadPnP<T, TD> alg, RefinePnPStereo refine, AssociateStereo2D<TD> associateStereo, PnPStereoDistanceReprojectionSq distance, DistanceModelMonoPixels<Se3_F64, Point2D3D> distanceMono, Class<T> imageType) {
        this.alg = alg;
        this.refine = refine;
        this.associateStereo = associateStereo;
        this.distance = distance;
        this.distanceMono = distanceMono;
        this.imageType = imageType;
    }

    @Override
    public Point3D_F64 getTrackLocation(int index) {
        FastQueue<VisOdomQuadPnP.QuadView> features = this.alg.getQuadViews();
        return ((VisOdomQuadPnP.QuadView)features.get((int)index)).X;
    }

    @Override
    public long getTrackId(int index) {
        return 0L;
    }

    @Override
    public List<Point2D_F64> getAllTracks() {
        FastQueue<VisOdomQuadPnP.QuadView> features = this.alg.getQuadViews();
        ArrayList<Point2D_F64> ret = new ArrayList<Point2D_F64>();
        for (VisOdomQuadPnP.QuadView v : features.toList()) {
            ret.add(v.v2);
        }
        return ret;
    }

    @Override
    public boolean isInlier(int index) {
        ModelMatcher<Se3_F64, Stereo2D3D> matcher = this.alg.getMatcher();
        int N = matcher.getMatchSet().size();
        for (int i = 0; i < N; ++i) {
            if (matcher.getInputIndex(i) != index) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNew(int index) {
        return false;
    }

    @Override
    public void setCalibration(StereoParameters parameters) {
        Se3_F64 leftToRight = parameters.getRightToLeft().invert(null);
        this.alg.setCalibration(parameters);
        this.associateStereo.setCalibration(parameters);
        this.distance.setStereoParameters(parameters);
        IntrinsicParameters left = parameters.left;
        this.distanceMono.setIntrinsic(left.fx, left.fy, left.skew);
        if (this.refine != null) {
            this.refine.setLeftToRight(leftToRight);
        }
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return this.alg.getLeftToWorld();
    }

    @Override
    public boolean process(T leftImage, T rightImage) {
        return this.alg.process(leftImage, rightImage);
    }

    @Override
    public boolean isFault() {
        return false;
    }

    @Override
    public ImageType<T> getImageType() {
        return ImageType.single(this.imageType);
    }
}

