/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.InterleavedI8;

public class InterleavedS8
extends InterleavedI8<InterleavedS8> {
    public InterleavedS8(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public InterleavedS8() {
    }

    @Override
    public ImageDataType getDataType() {
        return ImageDataType.S8;
    }

    @Override
    public int getBand(int x, int y, int band) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        return this.data[this.getIndex(x, y, band)];
    }

    @Override
    public void get_unsafe(int x, int y, int[] storage) {
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index];
            ++i;
            ++index;
        }
    }

    @Override
    public InterleavedS8 _createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new InterleavedS8();
        }
        return new InterleavedS8(imgWidth, imgHeight, this.numBands);
    }
}

