/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.kernel;

import boofcv.alg.filter.kernel.SteerableCoefficients;

public class FactorySteerCoefficients {
    public static SteerableCoefficients polynomial(int order) {
        if (order == 1) {
            return new PolyOrder1();
        }
        if (order == 2) {
            return new PolyOrder2();
        }
        if (order == 3) {
            return new PolyOrder3();
        }
        if (order == 4) {
            return new PolyOrder4();
        }
        throw new IllegalArgumentException("Only supports orders 1 to 4");
    }

    public static SteerableCoefficients separable(int order) {
        return new Separable(order);
    }

    public static class Separable
    implements SteerableCoefficients {
        final int order;

        public Separable(int order) {
            this.order = order;
        }

        @Override
        public double compute(double angle, int basis) {
            int powerC = this.order - basis;
            int middleIndex = Math.min(basis, this.order - basis);
            float middle = 1.0f;
            if (middleIndex > 0) {
                middle = this.order;
                int inc = this.order;
                for (int i = 1; i < middleIndex; ++i) {
                    middle += (float)(inc -= 2);
                }
            }
            middle = (float)((double)middle * Math.pow(-1.0, basis));
            return (double)middle * Math.pow(Math.cos(angle), powerC) * Math.pow(Math.sin(angle), basis);
        }
    }

    public static class PolyOrder4
    implements SteerableCoefficients {
        @Override
        public double compute(double angle, int basis) {
            return 0.2 * (1.0 + 2.0 * Math.cos(2.0 * (angle -= (double)basis * Math.PI / 5.0)) + 2.0 * Math.cos(4.0 * angle));
        }
    }

    public static class PolyOrder3
    implements SteerableCoefficients {
        @Override
        public double compute(double angle, int basis) {
            return 0.25 * (2.0 * Math.cos(angle -= (double)basis * Math.PI / 4.0) + 2.0 * Math.cos(3.0 * angle));
        }
    }

    public static class PolyOrder2
    implements SteerableCoefficients {
        @Override
        public double compute(double angle, int basis) {
            return 0.3333333333333333 * (1.0 + 2.0 * Math.cos(2.0 * (angle -= (double)basis * Math.PI / 3.0)));
        }
    }

    public static class PolyOrder1
    implements SteerableCoefficients {
        @Override
        public double compute(double angle, int basis) {
            if (basis == 0) {
                return Math.cos(angle);
            }
            return Math.sin(angle);
        }
    }
}

