/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.binary;

import boofcv.abst.filter.binary.GlobalEntropyBinaryFilter;
import boofcv.abst.filter.binary.GlobalFixedBinaryFilter;
import boofcv.abst.filter.binary.GlobalOtsuBinaryFilter;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.filter.binary.LocalGaussianBinaryFilter;
import boofcv.abst.filter.binary.LocalSauvolaBinaryFilter;
import boofcv.abst.filter.binary.LocalSquareBinaryFilter;
import boofcv.abst.filter.binary.LocalSquareBlockMinMaxBinaryFilter;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ConfigThresholdBlockMinMax;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class FactoryThresholdBinary {
    public static <T extends ImageGray> InputToBinary<T> localGaussian(int radius, double scale, boolean down, Class<T> inputType) {
        return new LocalGaussianBinaryFilter<T>(radius, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray> InputToBinary<T> localSauvola(int radius, float k, boolean down, Class<T> inputType) {
        return new LocalSauvolaBinaryFilter<T>(radius, k, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray> InputToBinary<T> localSquare(int radius, double scale, boolean down, Class<T> inputType) {
        return new LocalSquareBinaryFilter<T>(radius, scale, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray> InputToBinary<T> localSquareBlockMinMax(int regionWidth, double scale, boolean down, double minimumSpread, Class<T> inputType) {
        return new LocalSquareBlockMinMaxBinaryFilter<T>(minimumSpread, regionWidth, scale, down, inputType);
    }

    public static <T extends ImageGray> InputToBinary<T> globalEntropy(int minValue, int maxValue, boolean down, Class<T> inputType) {
        return new GlobalEntropyBinaryFilter<T>(minValue, maxValue, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray> InputToBinary<T> globalFixed(double threshold, boolean down, Class<T> inputType) {
        return new GlobalFixedBinaryFilter<T>(threshold, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray> InputToBinary<T> globalOtsu(int minValue, int maxValue, boolean down, Class<T> inputType) {
        return new GlobalOtsuBinaryFilter<T>(minValue, maxValue, down, ImageType.single(inputType));
    }

    public static <T extends ImageGray> InputToBinary<T> threshold(ConfigThreshold config, Class<T> inputType) {
        switch (config.type) {
            case FIXED: {
                return FactoryThresholdBinary.globalFixed(config.fixedThreshold, config.down, inputType);
            }
            case GLOBAL_OTSU: {
                return FactoryThresholdBinary.globalOtsu(config.minPixelValue, config.maxPixelValue, config.down, inputType);
            }
            case GLOBAL_ENTROPY: {
                return FactoryThresholdBinary.globalEntropy(config.minPixelValue, config.maxPixelValue, config.down, inputType);
            }
            case LOCAL_GAUSSIAN: {
                return FactoryThresholdBinary.localGaussian(config.radius, config.scale, config.down, inputType);
            }
            case LOCAL_SAVOLA: {
                return FactoryThresholdBinary.localSauvola(config.radius, config.savolaK, config.down, inputType);
            }
            case LOCAL_SQUARE: {
                return FactoryThresholdBinary.localSquare(config.radius, config.scale, config.down, inputType);
            }
            case LOCAL_SQUARE_BLOCK_MIN_MAX: {
                ConfigThresholdBlockMinMax c = (ConfigThresholdBlockMinMax)config;
                return FactoryThresholdBinary.localSquareBlockMinMax(c.radius * 2 + 1, c.scale, c.down, c.minimumSpread, inputType);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)config.type));
    }
}

