/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageInterleaved;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.InterleavedF32;
import boofcv.struct.image.InterleavedF64;
import boofcv.struct.image.InterleavedI16;
import boofcv.struct.image.InterleavedI8;
import boofcv.struct.image.InterleavedS16;
import boofcv.struct.image.InterleavedS32;
import boofcv.struct.image.InterleavedS64;
import boofcv.struct.image.InterleavedS8;
import boofcv.struct.image.InterleavedU16;
import boofcv.struct.image.InterleavedU8;
import boofcv.struct.image.Planar;
import java.util.Random;

public class GImageMiscOps {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copy(int srcX, int srcY, int dstX, int dstY, int width, int height, ImageBase input, ImageBase output) {
        if (input instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (GrayI8)input, (GrayI8)output);
                return;
            } else if (GrayI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (GrayI16)input, (GrayI16)output);
                return;
            } else if (GrayS32.class == input.getClass()) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (GrayS32)input, (GrayS32)output);
                return;
            } else if (GrayS64.class == input.getClass()) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (GrayS64)input, (GrayS64)output);
                return;
            } else if (GrayF32.class == input.getClass()) {
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (GrayF32)input, (GrayF32)output);
                return;
            } else {
                if (GrayF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, (GrayF64)input, (GrayF64)output);
            }
            return;
        } else {
            if (!(input instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            Planar mi = (Planar)input;
            Planar mo = (Planar)output;
            for (int i = 0; i < mi.getNumBands(); ++i) {
                GImageMiscOps.copy(srcX, srcY, dstX, dstY, width, height, mi.getBand(i), mo.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fill(ImageBase input, double value) {
        if (input instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((GrayI8)input, (int)value);
                return;
            } else if (GrayI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((GrayI16)input, (int)value);
                return;
            } else if (GrayS32.class == input.getClass()) {
                ImageMiscOps.fill((GrayS32)input, (int)value);
                return;
            } else if (GrayS64.class == input.getClass()) {
                ImageMiscOps.fill((GrayS64)input, (long)value);
                return;
            } else if (GrayF32.class == input.getClass()) {
                ImageMiscOps.fill((GrayF32)input, (float)value);
                return;
            } else {
                if (GrayF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fill((GrayF64)input, value);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((InterleavedI8)input, (int)value);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((InterleavedI16)input, (int)value);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedS32)input, (int)value);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedS64)input, (long)value);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedF32)input, (float)value);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fill((InterleavedF64)input, value);
            }
            return;
        } else {
            if (!(input instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            Planar m = (Planar)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fill(m.getBand(i), value);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fill(ImageBase input, double[] values) {
        if (input instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((GrayI8)input, (int)values[0]);
                return;
            } else if (GrayI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((GrayI16)input, (int)values[0]);
                return;
            } else if (GrayS32.class == input.getClass()) {
                ImageMiscOps.fill((GrayS32)input, (int)values[0]);
                return;
            } else if (GrayS64.class == input.getClass()) {
                ImageMiscOps.fill((GrayS64)input, (long)values[0]);
                return;
            } else if (GrayF32.class == input.getClass()) {
                ImageMiscOps.fill((GrayF32)input, (float)values[0]);
                return;
            } else {
                if (GrayF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fill((GrayF64)input, values[0]);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((InterleavedI8)input, BoofMiscOps.convertArray(values, (int[])null));
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fill((InterleavedI16)input, BoofMiscOps.convertArray(values, (int[])null));
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedS32)input, BoofMiscOps.convertArray(values, (int[])null));
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedS64)input, BoofMiscOps.convertArray(values, (long[])null));
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fill((InterleavedF32)input, BoofMiscOps.convertArray(values, (float[])null));
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fill((InterleavedF64)input, values);
            }
            return;
        } else {
            if (!(input instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            Planar m = (Planar)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fill(m.getBand(i), values[i]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillBand(ImageMultiBand input, int band, double value) {
        if (input instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillBand((InterleavedI8)input, band, (int)value);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillBand((InterleavedI16)input, band, (int)value);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fillBand((InterleavedS32)input, band, (int)value);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fillBand((InterleavedS64)input, band, (long)value);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fillBand((InterleavedF32)input, band, (float)value);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillBand((InterleavedF64)input, band, value);
            }
            return;
        } else {
            if (!(input instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            Planar m = (Planar)input;
            GImageMiscOps.fill(m.getBand(band), value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void insertBand(ImageGray input, int band, ImageMultiBand output) {
        if (output instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(output.getClass())) {
                ImageMiscOps.insertBand((GrayI8)input, band, (InterleavedI8)output);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(output.getClass())) {
                ImageMiscOps.insertBand((GrayI16)input, band, (InterleavedI16)output);
                return;
            } else if (InterleavedS32.class == output.getClass()) {
                ImageMiscOps.insertBand((GrayS32)input, band, (InterleavedS32)output);
                return;
            } else if (InterleavedS64.class == output.getClass()) {
                ImageMiscOps.insertBand((GrayS64)input, band, (InterleavedS64)output);
                return;
            } else if (InterleavedF32.class == output.getClass()) {
                ImageMiscOps.insertBand((GrayF32)input, band, (InterleavedF32)output);
                return;
            } else {
                if (InterleavedF64.class != output.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.insertBand((GrayF64)input, band, (InterleavedF64)output);
            }
            return;
        } else {
            if (!(output instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            Planar m = (Planar)output;
            m.getBand(band).setTo((ImageGray)input);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillBorder(ImageBase input, double value, int radius) {
        if (input instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillBorder((GrayI8)input, (int)value, radius);
                return;
            } else if (GrayI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillBorder((GrayI16)input, (int)value, radius);
                return;
            } else if (GrayS32.class == input.getClass()) {
                ImageMiscOps.fillBorder((GrayS32)input, (int)value, radius);
                return;
            } else if (GrayS64.class == input.getClass()) {
                ImageMiscOps.fillBorder((GrayS64)input, (long)value, radius);
                return;
            } else if (GrayF32.class == input.getClass()) {
                ImageMiscOps.fillBorder((GrayF32)input, (float)value, radius);
                return;
            } else {
                if (GrayF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillBorder((GrayF64)input, value, radius);
            }
            return;
        } else {
            if (!(input instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            Planar m = (Planar)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillBorder(m.getBand(i), value, radius);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillRectangle(ImageBase input, double value, int x0, int y0, int width, int height) {
        if (input instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillRectangle((GrayI8)input, (int)value, x0, y0, width, height);
                return;
            } else if (GrayI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillRectangle((GrayI16)input, (int)value, x0, y0, width, height);
                return;
            } else if (GrayS32.class == input.getClass()) {
                ImageMiscOps.fillRectangle((GrayS32)input, (int)value, x0, y0, width, height);
                return;
            } else if (GrayS64.class == input.getClass()) {
                ImageMiscOps.fillRectangle((GrayS64)input, (long)value, x0, y0, width, height);
                return;
            } else if (GrayF32.class == input.getClass()) {
                ImageMiscOps.fillRectangle((GrayF32)input, (float)value, x0, y0, width, height);
                return;
            } else {
                if (GrayF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillRectangle((GrayF64)input, value, x0, y0, width, height);
            }
            return;
        } else if (input instanceof Planar) {
            Planar m = (Planar)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillRectangle(m.getBand(i), value, x0, y0, width, height);
            }
            return;
        } else {
            if (!(input instanceof ImageInterleaved)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillRectangle((InterleavedI8)input, (byte)value, x0, y0, width, height);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillRectangle((InterleavedI16)input, (short)value, x0, y0, width, height);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fillRectangle((InterleavedS32)input, (int)value, x0, y0, width, height);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fillRectangle((InterleavedS64)input, (long)value, x0, y0, width, height);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fillRectangle((InterleavedF32)input, (float)value, x0, y0, width, height);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillRectangle((InterleavedF64)input, value, x0, y0, width, height);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillGaussian(ImageBase input, Random rand, double mean, double sigma, double lowerBound, double upperBound) {
        if (input instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillGaussian((GrayI8)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (GrayI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillGaussian((GrayI16)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (GrayS32.class == input.getClass()) {
                ImageMiscOps.fillGaussian((GrayS32)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (GrayS64.class == input.getClass()) {
                ImageMiscOps.fillGaussian((GrayS64)input, rand, mean, sigma, (long)lowerBound, (long)upperBound);
                return;
            } else if (GrayF32.class == input.getClass()) {
                ImageMiscOps.fillGaussian((GrayF32)input, rand, mean, sigma, (float)lowerBound, (float)upperBound);
                return;
            } else {
                if (GrayF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillGaussian((GrayF64)input, rand, mean, sigma, lowerBound, upperBound);
            }
            return;
        } else if (input instanceof Planar) {
            Planar m = (Planar)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillGaussian(input, rand, mean, sigma, lowerBound, upperBound);
            }
            return;
        } else {
            if (!(input instanceof ImageInterleaved)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillGaussian((InterleavedI8)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillGaussian((InterleavedI16)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fillGaussian((InterleavedS32)input, rand, mean, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fillGaussian((InterleavedS64)input, rand, mean, sigma, (long)lowerBound, (long)upperBound);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fillGaussian((InterleavedF32)input, rand, mean, sigma, (float)lowerBound, (float)upperBound);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillGaussian((InterleavedF64)input, rand, mean, sigma, lowerBound, upperBound);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void fillUniform(ImageBase input, Random rand, double min, double max) {
        if (input instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((GrayI8)input, rand, (int)min, (int)max - 1);
                return;
            } else if (GrayI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((GrayI16)input, rand, (int)min, (int)max - 1);
                return;
            } else if (GrayS32.class == input.getClass()) {
                ImageMiscOps.fillUniform((GrayS32)input, rand, (int)min, (int)max - 1);
                return;
            } else if (GrayS64.class == input.getClass()) {
                ImageMiscOps.fillUniform((GrayS64)input, rand, (long)min, (long)max - 1L);
                return;
            } else if (GrayF32.class == input.getClass()) {
                ImageMiscOps.fillUniform((GrayF32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (GrayF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillUniform((GrayF64)input, rand, min, max);
            }
            return;
        } else if (input instanceof ImageInterleaved) {
            if (InterleavedI8.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((InterleavedI8)input, rand, (int)min, (int)max - 1);
                return;
            } else if (InterleavedI16.class.isAssignableFrom(input.getClass())) {
                ImageMiscOps.fillUniform((InterleavedI16)input, rand, (int)min, (int)max - 1);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.fillUniform((InterleavedS32)input, rand, (int)min, (int)max - 1);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.fillUniform((InterleavedS64)input, rand, (long)min, (long)max - 1L);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.fillUniform((InterleavedF32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.fillUniform((InterleavedF64)input, rand, min, max);
            }
            return;
        } else {
            if (!(input instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            Planar m = (Planar)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.fillUniform(m.getBand(i), rand, min, max);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addGaussian(ImageBase input, Random rand, double sigma, double lowerBound, double upperBound) {
        if (input instanceof ImageGray) {
            if (GrayU8.class == input.getClass()) {
                ImageMiscOps.addGaussian((GrayU8)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (GrayS8.class == input.getClass()) {
                ImageMiscOps.addGaussian((GrayS8)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (GrayU16.class == input.getClass()) {
                ImageMiscOps.addGaussian((GrayU16)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (GrayS16.class == input.getClass()) {
                ImageMiscOps.addGaussian((GrayS16)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (GrayS32.class == input.getClass()) {
                ImageMiscOps.addGaussian((GrayS32)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (GrayS64.class == input.getClass()) {
                ImageMiscOps.addGaussian((GrayS64)input, rand, sigma, (long)lowerBound, (long)upperBound);
                return;
            } else if (GrayF32.class == input.getClass()) {
                ImageMiscOps.addGaussian((GrayF32)input, rand, sigma, (float)lowerBound, (float)upperBound);
                return;
            } else {
                if (GrayF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.addGaussian((GrayF64)input, rand, sigma, lowerBound, upperBound);
            }
            return;
        } else if (input instanceof Planar) {
            Planar m = (Planar)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.addGaussian(m.getBand(i), rand, sigma, lowerBound, upperBound);
            }
            return;
        } else {
            if (!(input instanceof ImageInterleaved)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            if (InterleavedU8.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedU8)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedS8)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedU16)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedS16)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedS32)input, rand, sigma, (int)lowerBound, (int)upperBound);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedS64)input, rand, sigma, (long)lowerBound, (long)upperBound);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.addGaussian((InterleavedF32)input, rand, sigma, (float)lowerBound, (float)upperBound);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.addGaussian((InterleavedF64)input, rand, sigma, lowerBound, upperBound);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addUniform(ImageBase input, Random rand, double min, double max) {
        if (input instanceof ImageGray) {
            if (GrayU8.class == input.getClass()) {
                ImageMiscOps.addUniform((GrayU8)input, rand, (int)min, (int)max);
                return;
            } else if (GrayS8.class == input.getClass()) {
                ImageMiscOps.addUniform((GrayS8)input, rand, (int)min, (int)max);
                return;
            } else if (GrayU16.class == input.getClass()) {
                ImageMiscOps.addUniform((GrayU16)input, rand, (int)min, (int)max);
                return;
            } else if (GrayS16.class == input.getClass()) {
                ImageMiscOps.addUniform((GrayS16)input, rand, (int)min, (int)max);
                return;
            } else if (GrayS32.class == input.getClass()) {
                ImageMiscOps.addUniform((GrayS32)input, rand, (int)min, (int)max);
                return;
            } else if (GrayS64.class == input.getClass()) {
                ImageMiscOps.addUniform((GrayS64)input, rand, (long)min, (long)max);
                return;
            } else if (GrayF32.class == input.getClass()) {
                ImageMiscOps.addUniform((GrayF32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (GrayF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.addUniform((GrayF64)input, rand, min, max);
            }
            return;
        } else if (input instanceof Planar) {
            Planar m = (Planar)input;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.addUniform(m.getBand(i), rand, min, max);
            }
            return;
        } else {
            if (!(input instanceof ImageInterleaved)) throw new IllegalArgumentException("Unknown image type: " + input.getClass().getSimpleName());
            if (InterleavedU8.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedU8)input, rand, (int)min, (int)max);
                return;
            } else if (InterleavedS8.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedS8)input, rand, (int)min, (int)max);
                return;
            } else if (InterleavedU16.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedU16)input, rand, (int)min, (int)max);
                return;
            } else if (InterleavedS16.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedS16)input, rand, (int)min, (int)max);
                return;
            } else if (InterleavedS32.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedS32)input, rand, (int)min, (int)max);
                return;
            } else if (InterleavedS64.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedS64)input, rand, (long)min, (long)max);
                return;
            } else if (InterleavedF32.class == input.getClass()) {
                ImageMiscOps.addUniform((InterleavedF32)input, rand, (float)min, (float)max);
                return;
            } else {
                if (InterleavedF64.class != input.getClass()) throw new IllegalArgumentException("Unknown image Type: " + input.getClass().getSimpleName());
                ImageMiscOps.addUniform((InterleavedF64)input, rand, min, max);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void flipVertical(ImageBase img) {
        if (img instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((GrayI8)img);
                return;
            } else if (GrayI16.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((GrayI16)img);
                return;
            } else if (GrayS32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((GrayS32)img);
                return;
            } else if (GrayS64.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((GrayS64)img);
                return;
            } else if (GrayF32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((GrayF32)img);
                return;
            } else if (GrayF64.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipVertical((GrayF64)img);
                return;
            } else {
                if (!GrayS64.class.isAssignableFrom(img.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
                ImageMiscOps.flipVertical((GrayS64)img);
            }
            return;
        } else {
            if (!(img instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + img.getClass().getSimpleName());
            Planar m = (Planar)img;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.flipVertical(m.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void flipHorizontal(ImageBase img) {
        if (img instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((GrayI8)img);
                return;
            } else if (GrayI16.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((GrayI16)img);
                return;
            } else if (GrayS32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((GrayS32)img);
                return;
            } else if (GrayS64.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((GrayS64)img);
                return;
            } else if (GrayF32.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((GrayF32)img);
                return;
            } else if (GrayF64.class.isAssignableFrom(img.getClass())) {
                ImageMiscOps.flipHorizontal((GrayF64)img);
                return;
            } else {
                if (!GrayS64.class.isAssignableFrom(img.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + img.getClass().getSimpleName());
                ImageMiscOps.flipHorizontal((GrayS64)img);
            }
            return;
        } else {
            if (!(img instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + img.getClass().getSimpleName());
            Planar m = (Planar)img;
            for (int i = 0; i < m.getNumBands(); ++i) {
                GImageMiscOps.flipHorizontal(m.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rotateCW(ImageBase image) {
        if (image instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((GrayI8)image);
                return;
            } else if (GrayI16.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((GrayI16)image);
                return;
            } else if (GrayS32.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((GrayS32)image);
                return;
            } else if (GrayS64.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((GrayS64)image);
                return;
            } else if (GrayF32.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((GrayF32)image);
                return;
            } else if (GrayF64.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCW((GrayF64)image);
                return;
            } else {
                if (!GrayS64.class.isAssignableFrom(image.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + image.getClass().getSimpleName());
                ImageMiscOps.rotateCW((GrayS64)image);
            }
            return;
        } else {
            if (!(image instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + image.getClass().getSimpleName());
            Planar a = (Planar)image;
            for (int i = 0; i < a.getNumBands(); ++i) {
                GImageMiscOps.rotateCW(a.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rotateCW(ImageBase imageA, ImageBase imageB) {
        if (imageA instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((GrayI8)imageA, (GrayI8)imageB);
                return;
            } else if (GrayI16.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((GrayI16)imageA, (GrayI16)imageB);
                return;
            } else if (GrayS32.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((GrayS32)imageA, (GrayS32)imageB);
                return;
            } else if (GrayS64.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((GrayS64)imageA, (GrayS64)imageB);
                return;
            } else if (GrayF32.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((GrayF32)imageA, (GrayF32)imageB);
                return;
            } else if (GrayF64.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCW((GrayF64)imageA, (GrayF64)imageB);
                return;
            } else {
                if (!GrayS64.class.isAssignableFrom(imageA.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + imageA.getClass().getSimpleName());
                ImageMiscOps.rotateCW((GrayS64)imageA, (GrayS64)imageB);
            }
            return;
        } else {
            if (!(imageA instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + imageA.getClass().getSimpleName());
            Planar a = (Planar)imageA;
            Planar b = (Planar)imageB;
            for (int i = 0; i < a.getNumBands(); ++i) {
                GImageMiscOps.rotateCW(a.getBand(i), b.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rotateCCW(ImageBase image) {
        if (image instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((GrayI8)image);
                return;
            } else if (GrayI16.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((GrayI16)image);
                return;
            } else if (GrayS32.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((GrayS32)image);
                return;
            } else if (GrayS64.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((GrayS64)image);
                return;
            } else if (GrayF32.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((GrayF32)image);
                return;
            } else if (GrayF64.class.isAssignableFrom(image.getClass())) {
                ImageMiscOps.rotateCCW((GrayF64)image);
                return;
            } else {
                if (!GrayS64.class.isAssignableFrom(image.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + image.getClass().getSimpleName());
                ImageMiscOps.rotateCCW((GrayS64)image);
            }
            return;
        } else {
            if (!(image instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + image.getClass().getSimpleName());
            Planar a = (Planar)image;
            for (int i = 0; i < a.getNumBands(); ++i) {
                GImageMiscOps.rotateCCW(a.getBand(i));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void rotateCCW(ImageBase imageA, ImageBase imageB) {
        if (imageA instanceof ImageGray) {
            if (GrayI8.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((GrayI8)imageA, (GrayI8)imageB);
                return;
            } else if (GrayI16.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((GrayI16)imageA, (GrayI16)imageB);
                return;
            } else if (GrayS32.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((GrayS32)imageA, (GrayS32)imageB);
                return;
            } else if (GrayS64.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((GrayS64)imageA, (GrayS64)imageB);
                return;
            } else if (GrayF32.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((GrayF32)imageA, (GrayF32)imageB);
                return;
            } else if (GrayF64.class.isAssignableFrom(imageA.getClass())) {
                ImageMiscOps.rotateCCW((GrayF64)imageA, (GrayF64)imageB);
                return;
            } else {
                if (!GrayS64.class.isAssignableFrom(imageA.getClass())) throw new IllegalArgumentException("Unknown or incompatible image type: " + imageA.getClass().getSimpleName());
                ImageMiscOps.rotateCCW((GrayS64)imageA, (GrayS64)imageB);
            }
            return;
        } else {
            if (!(imageA instanceof Planar)) throw new IllegalArgumentException("Unknown image type: " + imageA.getClass().getSimpleName());
            Planar a = (Planar)imageA;
            Planar b = (Planar)imageB;
            for (int i = 0; i < a.getNumBands(); ++i) {
                GImageMiscOps.rotateCCW(a.getBand(i), b.getBand(i));
            }
        }
    }
}

