/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.misc;

import boofcv.alg.filter.misc.ImplAverageDownSample;
import boofcv.alg.filter.misc.ImplAverageDownSample2;
import boofcv.alg.filter.misc.ImplAverageDownSampleN;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;

public class AverageDownSampleOps {
    public static int downSampleSize(int length, int squareWidth) {
        int ret = length / squareWidth;
        if (length % squareWidth != 0) {
            ++ret;
        }
        return ret;
    }

    public static void reshapeDown(ImageBase image, int inputWidth, int inputHeight, int squareWidth) {
        int w = AverageDownSampleOps.downSampleSize(inputWidth, squareWidth);
        int h = AverageDownSampleOps.downSampleSize(inputHeight, squareWidth);
        image.reshape(w, h);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void down(ImageGray input, int sampleWidth, ImageGray output) {
        if (sampleWidth == 2) {
            if (input instanceof GrayU8) {
                ImplAverageDownSample2.down((GrayU8)input, (GrayI8)output);
                return;
            } else if (input instanceof GrayS8) {
                ImplAverageDownSample2.down((GrayS8)input, (GrayI8)output);
                return;
            } else if (input instanceof GrayU16) {
                ImplAverageDownSample2.down((GrayU16)input, (GrayI16)output);
                return;
            } else if (input instanceof GrayS16) {
                ImplAverageDownSample2.down((GrayS16)input, (GrayI16)output);
                return;
            } else if (input instanceof GrayS32) {
                ImplAverageDownSample2.down((GrayS32)input, (GrayS32)output);
                return;
            } else if (input instanceof GrayF32) {
                ImplAverageDownSample2.down((GrayF32)input, (GrayF32)output);
                return;
            } else {
                if (!(input instanceof GrayF64)) throw new IllegalArgumentException("Unknown image type");
                ImplAverageDownSample2.down((GrayF64)input, (GrayF64)output);
            }
            return;
        } else if (input instanceof GrayU8) {
            ImplAverageDownSampleN.down((GrayU8)input, sampleWidth, (GrayI8)output);
            return;
        } else if (input instanceof GrayS8) {
            ImplAverageDownSampleN.down((GrayS8)input, sampleWidth, (GrayI8)output);
            return;
        } else if (input instanceof GrayU16) {
            ImplAverageDownSampleN.down((GrayU16)input, sampleWidth, (GrayI16)output);
            return;
        } else if (input instanceof GrayS16) {
            ImplAverageDownSampleN.down((GrayS16)input, sampleWidth, (GrayI16)output);
            return;
        } else if (input instanceof GrayS32) {
            ImplAverageDownSampleN.down((GrayS32)input, sampleWidth, (GrayS32)output);
            return;
        } else if (input instanceof GrayF32) {
            ImplAverageDownSampleN.down((GrayF32)input, sampleWidth, (GrayF32)output);
            return;
        } else {
            if (!(input instanceof GrayF64)) throw new IllegalArgumentException("Unknown image type");
            ImplAverageDownSampleN.down((GrayF64)input, sampleWidth, (GrayF64)output);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends ImageBase> void down(T input, T output) {
        if (ImageGray.class.isAssignableFrom(input.getClass())) {
            if (input instanceof GrayU8) {
                GrayF32 middle = new GrayF32(output.width, input.height);
                ImplAverageDownSample.horizontal((GrayU8)input, middle);
                ImplAverageDownSample.vertical(middle, (GrayI8)output);
                return;
            } else if (input instanceof GrayU16) {
                GrayF32 middle = new GrayF32(output.width, input.height);
                ImplAverageDownSample.horizontal((GrayU16)input, middle);
                ImplAverageDownSample.vertical(middle, (GrayU16)output);
                return;
            } else if (input instanceof GrayF32) {
                GrayF32 middle = new GrayF32(output.width, input.height);
                ImplAverageDownSample.horizontal((GrayF32)input, middle);
                ImplAverageDownSample.vertical(middle, (GrayF32)output);
                return;
            } else {
                if (!(input instanceof GrayF64)) throw new IllegalArgumentException("Unknown image type");
                GrayF64 middle = new GrayF64(output.width, input.height);
                ImplAverageDownSample.horizontal((GrayF64)input, middle);
                ImplAverageDownSample.vertical(middle, (GrayF64)output);
            }
            return;
        } else {
            if (!Planar.class.isAssignableFrom(input.getClass())) return;
            Planar in = (Planar)input;
            Planar out = (Planar)output;
            int N = in.getNumBands();
            for (int i = 0; i < N; ++i) {
                AverageDownSampleOps.down(in.getBand(i), out.getBand(i));
            }
        }
    }

    public static <T extends ImageGray> void down(Planar<T> input, int sampleWidth, Planar<T> output) {
        for (int band = 0; band < input.getNumBands(); ++band) {
            AverageDownSampleOps.down(input.getBand(band), sampleWidth, output.getBand(band));
        }
    }

    public static <T extends ImageGray> void down(Planar<T> input, Planar<T> output) {
        for (int band = 0; band < input.getNumBands(); ++band) {
            AverageDownSampleOps.down(input.getBand(band), output.getBand(band));
        }
    }

    public static void down(GrayU8 input, int sampleWidth, GrayI8 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayS8 input, int sampleWidth, GrayI8 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayU16 input, int sampleWidth, GrayI16 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayS16 input, int sampleWidth, GrayI16 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayS32 input, int sampleWidth, GrayS32 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayF32 input, int sampleWidth, GrayF32 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }

    public static void down(GrayF64 input, int sampleWidth, GrayF64 output) {
        if (sampleWidth == 2) {
            ImplAverageDownSample2.down(input, output);
        } else {
            ImplAverageDownSampleN.down(input, sampleWidth, output);
        }
    }
}

