/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.binary.impl;

import boofcv.alg.filter.binary.ThresholdSquareBlockMinMax;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.InterleavedU8;

public class ThresholdSquareBlockMinMax_U8
extends ThresholdSquareBlockMinMax<GrayU8, InterleavedU8> {
    double scale;
    boolean down;

    public ThresholdSquareBlockMinMax_U8(double minimumSpread, int requestedBlockWidth, double scale, boolean down) {
        super(minimumSpread, requestedBlockWidth);
        this.minmax = new InterleavedU8(1, 1, 2);
        this.scale = scale;
        this.down = down;
    }

    @Override
    protected void thresholdBlock(int blockX0, int blockY0, GrayU8 input, GrayU8 output) {
        int x0 = blockX0 * this.blockWidth;
        int y0 = blockY0 * this.blockHeight;
        int x1 = blockX0 == ((InterleavedU8)this.minmax).width - 1 ? input.width : (blockX0 + 1) * this.blockWidth;
        int y1 = blockY0 == ((InterleavedU8)this.minmax).height - 1 ? input.height : (blockY0 + 1) * this.blockHeight;
        int blockX1 = Math.min(((InterleavedU8)this.minmax).width - 1, blockX0 + 1);
        int blockY1 = Math.min(((InterleavedU8)this.minmax).height - 1, blockY0 + 1);
        blockX0 = Math.max(0, blockX0 - 1);
        blockY0 = Math.max(0, blockY0 - 1);
        int min = Integer.MAX_VALUE;
        int max = -2147483647;
        for (int y = blockY0; y <= blockY1; ++y) {
            for (int x = blockX0; x <= blockX1; ++x) {
                int localMin = ((InterleavedU8)this.minmax).getBand(x, y, 0);
                int localMax = ((InterleavedU8)this.minmax).getBand(x, y, 1);
                if (localMin < min) {
                    min = localMin;
                }
                if (localMax <= max) continue;
                max = localMax;
            }
        }
        int textureThreshold = (int)this.minimumSpread;
        for (int y = y0; y < y1; ++y) {
            int indexInput = input.startIndex + y * input.stride + x0;
            int indexOutput = output.startIndex + y * output.stride + x0;
            int x = x0;
            while (x < x1) {
                int average;
                output.data[indexOutput] = max - min <= textureThreshold ? (byte)1 : (this.down == (input.data[indexInput] & 0xFF) <= (average = (int)(this.scale * (double)((max + min) / 2))) ? (byte)1 : 0);
                ++x;
                ++indexOutput;
                ++indexInput;
            }
        }
    }

    @Override
    protected void computeMinMaxBlock(int x0, int y0, int width, int height, int indexMinMax, GrayU8 input) {
        int max;
        int min = max = input.unsafe_get(x0, y0);
        for (int y = 0; y < height; ++y) {
            int indexInput = input.startIndex + (y0 + y) * input.stride + x0;
            for (int x = 0; x < width; ++x) {
                int value;
                if ((value = input.data[indexInput++] & 0xFF) < min) {
                    min = value;
                    continue;
                }
                if (value <= max) continue;
                max = value;
            }
        }
        ((InterleavedU8)this.minmax).data[indexMinMax] = (byte)min;
        ((InterleavedU8)this.minmax).data[indexMinMax + 1] = (byte)max;
    }
}

