/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.color;

import boofcv.alg.InputSanityCheck;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;

public class ColorYuv {
    public static void rgbToYuv(double r, double g, double b, double[] yuv) {
        double y = yuv[0] = 0.299 * r + 0.587 * g + 0.114 * b;
        yuv[1] = 0.492 * (b - y);
        yuv[2] = 0.877 * (r - y);
    }

    public static void rgbToYuv(float r, float g, float b, float[] yuv) {
        float y = yuv[0] = 0.299f * r + 0.587f * g + 0.114f * b;
        yuv[1] = 0.492f * (b - y);
        yuv[2] = 0.877f * (r - y);
    }

    public static void yuvToRgb(double y, double u, double v, double[] rgb) {
        rgb[0] = y + 1.13983 * v;
        rgb[1] = y - 0.39465 * u - 0.5806 * v;
        rgb[2] = y + 2.032 * u;
    }

    public static void yuvToRgb(float y, float u, float v, float[] rgb) {
        rgb[0] = y + 1.13983f * v;
        rgb[1] = y - 0.39465f * u - 0.5806f * v;
        rgb[2] = y + 2.032f * u;
    }

    public static void rgbToYCbCr(int r, int g, int b, byte[] yuv) {
        yuv[0] = (byte)((187 * r + 629 * g + 63 * b >> 10) + 16);
        yuv[1] = (byte)((-103 * r - 346 * g + 450 * b >> 10) + 128);
        yuv[2] = (byte)((450 * r - 409 * g - 41 * b >> 10) + 128);
    }

    public static void ycbcrToRgb(int y, int cb, int cr, byte[] rgb) {
        if ((y = 1191 * (y - 16)) < 0) {
            y = 0;
        }
        int r = y + 1836 * (cr -= 128) >> 10;
        int g = y - 547 * cr - 218 * (cb -= 128) >> 10;
        int b = y + 2165 * cb >> 10;
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        rgb[0] = (byte)r;
        rgb[1] = (byte)g;
        rgb[2] = (byte)b;
    }

    public static void yuvToRgb_F32(Planar<GrayF32> yuv, Planar<GrayF32> rgb) {
        InputSanityCheck.checkSameShape(yuv, rgb);
        GrayF32 Y = yuv.getBand(0);
        GrayF32 U = yuv.getBand(1);
        GrayF32 V = yuv.getBand(2);
        GrayF32 R = rgb.getBand(0);
        GrayF32 G = rgb.getBand(1);
        GrayF32 B = rgb.getBand(2);
        for (int row = 0; row < yuv.height; ++row) {
            int indexYuv = yuv.startIndex + row * yuv.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < yuv.width) {
                float y = Y.data[indexYuv];
                float u = U.data[indexYuv];
                float v = V.data[indexYuv];
                R.data[indexRgb] = y + 1.13983f * v;
                G.data[indexRgb] = y - 0.39465f * u - 0.5806f * v;
                B.data[indexRgb] = y + 2.032f * u;
                ++col;
                ++indexYuv;
                ++indexRgb;
            }
        }
    }

    public static void rgbToYuv_F32(Planar<GrayF32> rgb, Planar<GrayF32> yuv) {
        InputSanityCheck.checkSameShape(yuv, rgb);
        GrayF32 R = rgb.getBand(0);
        GrayF32 G = rgb.getBand(1);
        GrayF32 B = rgb.getBand(2);
        GrayF32 Y = yuv.getBand(0);
        GrayF32 U = yuv.getBand(1);
        GrayF32 V = yuv.getBand(2);
        for (int row = 0; row < yuv.height; ++row) {
            int indexYuv = yuv.startIndex + row * yuv.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < yuv.width) {
                float y;
                float r = R.data[indexRgb];
                float g = G.data[indexRgb];
                float b = B.data[indexRgb];
                Y.data[indexYuv] = y = 0.299f * r + 0.587f * g + 0.114f * b;
                U.data[indexYuv] = 0.492f * (b - y);
                V.data[indexYuv] = 0.877f * (r - y);
                ++col;
                ++indexYuv;
                ++indexRgb;
            }
        }
    }

    public static void ycbcrToRgb_U8(Planar<GrayU8> yuv, Planar<GrayU8> rgb) {
        GrayU8 Y = yuv.getBand(0);
        GrayU8 U = yuv.getBand(1);
        GrayU8 V = yuv.getBand(2);
        GrayU8 R = rgb.getBand(0);
        GrayU8 G = rgb.getBand(1);
        GrayU8 B = rgb.getBand(2);
        for (int row = 0; row < yuv.height; ++row) {
            int indexYuv = yuv.startIndex + row * yuv.stride;
            int indexRgb = rgb.startIndex + row * rgb.stride;
            int col = 0;
            while (col < yuv.width) {
                int y = 1191 * ((Y.data[indexYuv] & 0xFF) - 16);
                int cb = (U.data[indexYuv] & 0xFF) - 128;
                int cr = (V.data[indexYuv] & 0xFF) - 128;
                if (y < 0) {
                    y = 0;
                }
                int r = y + 1836 * cr >> 10;
                int g = y - 547 * cr - 218 * cb >> 10;
                int b = y + 2165 * cb >> 10;
                if (r < 0) {
                    r = 0;
                } else if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                } else if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                } else if (b > 255) {
                    b = 255;
                }
                R.data[indexRgb] = (byte)r;
                G.data[indexRgb] = (byte)g;
                B.data[indexRgb] = (byte)b;
                ++col;
                ++indexYuv;
                ++indexRgb;
            }
        }
    }
}

