/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.filter.convolve;

import boofcv.abst.filter.convolve.ConvolveInterface;
import boofcv.core.image.border.BorderType;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GenericConvolveDown<Input extends ImageGray, Output extends ImageGray>
implements ConvolveInterface<Input, Output> {
    Method m;
    KernelBase kernel;
    BorderType type;
    int skip;
    Class<Input> inputType;
    Class<Output> outputType;

    public GenericConvolveDown(Method m, KernelBase kernel, BorderType type, int skip, Class<Input> inputType, Class<Output> outputType) {
        this.m = m;
        this.kernel = kernel;
        this.type = type;
        this.skip = skip;
        this.inputType = inputType;
        this.outputType = outputType;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    @Override
    public void process(Input input, Output output) {
        try {
            this.m.invoke(null, this.kernel, input, output, this.skip);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getHorizontalBorder() {
        if (this.type == BorderType.SKIP) {
            return this.kernel.getRadius();
        }
        return 0;
    }

    @Override
    public int getVerticalBorder() {
        return this.getHorizontalBorder();
    }

    @Override
    public BorderType getBorderType() {
        return this.type;
    }

    @Override
    public ImageType<Input> getInputType() {
        return ImageType.single(this.inputType);
    }

    @Override
    public ImageType<Output> getOutputType() {
        return ImageType.single(this.outputType);
    }
}

