/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.triangulate;

import boofcv.abst.geo.RefineTriangulationCalibrated;
import boofcv.alg.geo.triangulate.ResidualsTriangulateSimple;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;

public class LeastSquaresTriangulateCalibrated
implements RefineTriangulationCalibrated {
    ResidualsTriangulateSimple func = new ResidualsTriangulateSimple();
    UnconstrainedLeastSquares minimizer;
    double[] param = new double[3];
    int maxIterations;
    double convergenceTol;

    public LeastSquaresTriangulateCalibrated(double convergenceTol, int maxIterations) {
        this.convergenceTol = convergenceTol;
        this.maxIterations = maxIterations;
        this.minimizer = FactoryOptimization.leastSquareLevenberg((double)0.001);
    }

    @Override
    public boolean process(List<Point2D_F64> observations, List<Se3_F64> worldToCamera, Point3D_F64 worldPt, Point3D_F64 refinedPt) {
        this.func.setObservations(observations, worldToCamera);
        this.minimizer.setFunction((FunctionNtoM)this.func, null);
        this.param[0] = worldPt.x;
        this.param[1] = worldPt.y;
        this.param[2] = worldPt.z;
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)observations.size());
        for (int i = 0; i < this.maxIterations && !this.minimizer.iterate(); ++i) {
        }
        double[] found = this.minimizer.getParameters();
        refinedPt.x = found[0];
        refinedPt.y = found[1];
        refinedPt.z = found[2];
        return true;
    }
}

