/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation;

import boofcv.abst.feature.orientation.OrientationGradient;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ImageRectangle;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.image.ImageGray;

public abstract class OrientationAverage<D extends ImageGray>
implements OrientationGradient<D> {
    protected D derivX;
    protected D derivY;
    protected ImageRectangle rect = new ImageRectangle();
    protected double objectToSample;
    protected int sampleRadius;
    protected int radiusScale;
    protected boolean isWeighted;
    protected Kernel2D_F32 weights;

    protected OrientationAverage(double objectRadiusToScale, boolean weighted) {
        this.objectToSample = objectRadiusToScale;
        this.isWeighted = weighted;
    }

    public int getSampleRadius() {
        return this.sampleRadius;
    }

    public void setSampleRadius(int sampleRadius) {
        this.sampleRadius = sampleRadius;
        this.setObjectRadius(sampleRadius);
    }

    public Kernel2D_F32 getWeights() {
        return this.weights;
    }

    @Override
    public void setObjectRadius(double radius) {
        this.radiusScale = (int)Math.ceil(radius * this.objectToSample);
        if (this.isWeighted) {
            this.weights = (Kernel2D_F32)FactoryKernelGaussian.gaussian((int)2, (boolean)true, (int)32, (double)-1.0, (int)this.radiusScale);
        }
    }

    @Override
    public void setImage(D derivX, D derivY) {
        this.derivX = derivX;
        this.derivY = derivY;
    }

    @Override
    public double compute(double X, double Y) {
        int c_x = (int)X;
        int c_y = (int)Y;
        this.rect.x0 = c_x - this.radiusScale;
        this.rect.y0 = c_y - this.radiusScale;
        this.rect.x1 = c_x + this.radiusScale + 1;
        this.rect.y1 = c_y + this.radiusScale + 1;
        BoofMiscOps.boundRectangleInside(this.derivX, (ImageRectangle)this.rect);
        if (this.weights == null) {
            return this.computeUnweightedScore();
        }
        return this.computeWeightedScore(c_x, c_y);
    }

    protected abstract double computeUnweightedScore();

    protected abstract double computeWeightedScore(int var1, int var2);
}

