/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line.gridline;

import boofcv.alg.feature.detect.line.GridRansacLineDetector;
import boofcv.alg.feature.detect.line.gridline.Edgel;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import georegression.metric.UtilAngle;
import georegression.struct.line.LinePolar2D_F32;
import org.ddogleg.fitting.modelset.ModelMatcher;

public class ImplGridRansacLineDetector_F32
extends GridRansacLineDetector<GrayF32> {
    public ImplGridRansacLineDetector_F32(int regionSize, int maxDetectLines, ModelMatcher<LinePolar2D_F32, Edgel> robustMatcher) {
        super(regionSize, maxDetectLines, robustMatcher);
    }

    @Override
    protected void detectEdgels(int index0, int x0, int y0, GrayF32 derivX, GrayF32 derivY, GrayU8 binaryEdges) {
        this.edgels.reset();
        for (int y = 0; y < this.regionSize; ++y) {
            int index = index0 + y * binaryEdges.stride;
            for (int x = 0; x < this.regionSize; ++x) {
                if (binaryEdges.data[index++] == 0) continue;
                Edgel e = (Edgel)((Object)this.edgels.grow());
                int xx = x0 + x;
                int yy = y0 + y;
                e.set(xx, yy);
                float dx = derivX.unsafe_get(xx, yy);
                float dy = derivY.unsafe_get(xx, yy);
                e.theta = UtilAngle.atanSafe((float)dy, (float)dx);
            }
        }
    }
}

