/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration;

public class Zhang99ParamCamera {
    public double a;
    public double b;
    public double c;
    public double x0;
    public double y0;
    public double[] radial;
    public double t1;
    public double t2;
    public boolean assumeZeroSkew;
    public boolean includeTangential;

    public Zhang99ParamCamera(boolean assumeZeroSkew, int numRadial, boolean includeTangential) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.radial = new double[numRadial];
        this.includeTangential = includeTangential;
    }

    public Zhang99ParamCamera() {
    }

    public void zeroNotUsed() {
        if (this.assumeZeroSkew) {
            this.c = 0.0;
        }
        if (!this.includeTangential) {
            this.t2 = 0.0;
            this.t1 = 0.0;
        }
    }

    public int numParameters() {
        int total = 4 + this.radial.length;
        if (!this.assumeZeroSkew) {
            ++total;
        }
        if (this.includeTangential) {
            total += 2;
        }
        return total;
    }

    public int setFromParam(double[] param) {
        int index = 0;
        this.a = param[index++];
        this.b = param[index++];
        if (!this.assumeZeroSkew) {
            this.c = param[index++];
        }
        this.x0 = param[index++];
        this.y0 = param[index++];
        for (int i = 0; i < this.radial.length; ++i) {
            this.radial[i] = param[index++];
        }
        if (this.includeTangential) {
            this.t1 = param[index++];
            this.t2 = param[index++];
        }
        return index;
    }

    public int convertToParam(double[] param) {
        int index = 0;
        param[index++] = this.a;
        param[index++] = this.b;
        if (!this.assumeZeroSkew) {
            param[index++] = this.c;
        }
        param[index++] = this.x0;
        param[index++] = this.y0;
        for (int i = 0; i < this.radial.length; ++i) {
            param[index++] = this.radial[i];
        }
        if (this.includeTangential) {
            param[index++] = this.t1;
            param[index++] = this.t2;
        }
        return index;
    }
}

