/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.calibration;

import boofcv.abst.geo.calibration.CalibrationDetector;
import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.CalibrationPlanarGridZhang99;
import boofcv.alg.geo.calibration.Zhang99OptimizationFunction;
import boofcv.alg.geo.calibration.Zhang99ParamAll;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class CalibrateMonoPlanar {
    protected CalibrationDetector detector;
    protected CalibrationPlanarGridZhang99 zhang99;
    protected Zhang99ParamAll foundZhang;
    protected IntrinsicParameters foundIntrinsic;
    protected List<CalibrationObservation> observations = new ArrayList<CalibrationObservation>();
    protected List<ImageResults> errors;
    public boolean verbose = false;
    private int widthImg;
    private int heightImg;

    public CalibrateMonoPlanar(CalibrationDetector detector) {
        this.detector = detector;
    }

    public void configure(boolean assumeZeroSkew, int numRadialParam, boolean includeTangential) {
        this.zhang99 = new CalibrationPlanarGridZhang99(this.detector.getLayout(), assumeZeroSkew, numRadialParam, includeTangential);
    }

    public void reset() {
        this.observations = new ArrayList<CalibrationObservation>();
        this.errors = null;
        this.widthImg = 0;
        this.heightImg = 0;
    }

    public boolean addImage(GrayF32 image) {
        if (this.widthImg == 0) {
            this.widthImg = image.width;
            this.heightImg = image.height;
        } else if (this.widthImg != image.width || this.heightImg != image.height) {
            throw new IllegalArgumentException("All images must have the same shape");
        }
        if (!this.detector.process(image)) {
            return false;
        }
        this.observations.add(this.detector.getDetectedPoints());
        return true;
    }

    public void removeLatestImage() {
        this.observations.remove(this.observations.size() - 1);
    }

    public IntrinsicParameters process() {
        if (this.zhang99 == null) {
            throw new IllegalArgumentException("Please call configure first.");
        }
        if (!this.zhang99.process(this.observations)) {
            throw new RuntimeException("Zhang99 algorithm failed!");
        }
        this.foundZhang = this.zhang99.getOptimized();
        this.errors = CalibrateMonoPlanar.computeErrors(this.observations, this.foundZhang, this.detector.getLayout());
        this.foundIntrinsic = this.foundZhang.convertToIntrinsic();
        this.foundIntrinsic.width = this.widthImg;
        this.foundIntrinsic.height = this.heightImg;
        return this.foundIntrinsic;
    }

    public void printStatistics() {
        CalibrateMonoPlanar.printErrors(this.errors);
    }

    public static List<ImageResults> computeErrors(List<CalibrationObservation> observation, Zhang99ParamAll param, List<Point2D_F64> grid) {
        Zhang99OptimizationFunction function = new Zhang99OptimizationFunction(param, grid, observation);
        double[] residuals = new double[grid.size() * observation.size() * 2];
        function.process(param, residuals);
        ArrayList<ImageResults> ret = new ArrayList<ImageResults>();
        int N = grid.size();
        int index = 0;
        for (int indexObs = 0; indexObs < observation.size(); ++indexObs) {
            ImageResults r = new ImageResults(N);
            double meanX = 0.0;
            double meanY = 0.0;
            double meanErrorMag = 0.0;
            double maxError = 0.0;
            for (int i = 0; i < N; ++i) {
                double errorMag;
                double errorX = residuals[index++];
                double errorY = residuals[index++];
                r.pointError[i] = errorMag = Math.sqrt(errorX * errorX + errorY * errorY);
                meanX += errorX;
                meanY += errorY;
                meanErrorMag += errorMag;
                if (!(maxError < errorMag)) continue;
                maxError = errorMag;
            }
            r.biasX = meanX /= (double)N;
            r.biasY = meanY /= (double)N;
            r.meanError = meanErrorMag /= (double)N;
            r.maxError = maxError;
            ret.add(r);
        }
        return ret;
    }

    public static void printErrors(List<ImageResults> results) {
        double totalError = 0.0;
        for (int i = 0; i < results.size(); ++i) {
            ImageResults r = results.get(i);
            totalError += r.meanError;
            System.out.printf("image %3d Euclidean ( mean = %7.1e max = %7.1e ) bias ( X = %8.1e Y %8.1e )\n", i, r.meanError, r.maxError, r.biasX, r.biasY);
        }
        System.out.println("Average Mean Error = " + totalError / (double)results.size());
    }

    public List<CalibrationObservation> getObservations() {
        return this.observations;
    }

    public List<ImageResults> getErrors() {
        return this.errors;
    }

    public Zhang99ParamAll getZhangParam() {
        return this.foundZhang;
    }

    public IntrinsicParameters getIntrinsic() {
        return this.foundIntrinsic;
    }
}

