/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.LogLevel;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.DerivedRelationshipData;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.TransactionEvent;
import com.avaje.ebeaninternal.server.lucene.LIndexUpdateFuture;
import com.avaje.ebeaninternal.server.lucene.PersistenceLuceneException;
import com.avaje.ebeaninternal.server.persist.BatchControl;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import com.avaje.ebeaninternal.server.transaction.TransactionLogBuffer;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.PersistenceException;
import javax.persistence.RollbackException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcTransaction
implements SpiTransaction {
    private static final Logger logger = Logger.getLogger(JdbcTransaction.class.getName());
    private static final String illegalStateMessage = "Transaction is Inactive";
    protected final TransactionManager manager;
    final String id;
    final boolean explicit;
    final TransactionManager.OnQueryOnly onQueryOnly;
    boolean active;
    Connection connection;
    BatchControl batchControl;
    TransactionEvent event;
    PersistenceContext persistenceContext;
    boolean persistCascade = true;
    boolean queryOnly = true;
    boolean localReadOnly;
    LogLevel logLevel;
    boolean batchMode;
    int batchSize = -1;
    boolean batchFlushOnQuery = true;
    Boolean batchGetGeneratedKeys;
    Boolean batchFlushOnMixed;
    int depth = 0;
    HashSet<Object> persistingBeans = new HashSet();
    HashSet<Integer> deletingBeansHash;
    TransactionLogBuffer logBuffer;
    List<LIndexUpdateFuture> indexUpdateFutures;
    HashMap<Integer, List<DerivedRelationshipData>> derivedRelMap;

    public JdbcTransaction(String id, boolean explicit, LogLevel logLevel, Connection connection, TransactionManager manager) {
        try {
            this.active = true;
            this.id = id;
            this.explicit = explicit;
            this.logLevel = logLevel;
            this.manager = manager;
            this.connection = connection;
            this.onQueryOnly = manager == null ? TransactionManager.OnQueryOnly.ROLLBACK : manager.getOnQueryOnly();
            this.persistenceContext = new DefaultPersistenceContext();
            this.logBuffer = new TransactionLogBuffer(50, id);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public String toString() {
        return "Trans[" + this.id + "]";
    }

    @Override
    public List<DerivedRelationshipData> getDerivedRelationship(Object bean) {
        if (this.derivedRelMap == null) {
            return null;
        }
        Integer key = System.identityHashCode(bean);
        return this.derivedRelMap.get(key);
    }

    @Override
    public void registerDerivedRelationship(DerivedRelationshipData derivedRelationship) {
        Integer key;
        List<DerivedRelationshipData> list;
        if (this.derivedRelMap == null) {
            this.derivedRelMap = new HashMap();
        }
        if ((list = this.derivedRelMap.get(key = Integer.valueOf(System.identityHashCode(derivedRelationship.getAssocBean())))) == null) {
            list = new ArrayList<DerivedRelationshipData>();
            this.derivedRelMap.put(key, list);
        }
        list.add(derivedRelationship);
    }

    @Override
    public void addIndexUpdateFuture(LIndexUpdateFuture future) {
        if (this.indexUpdateFutures == null) {
            this.indexUpdateFutures = new ArrayList<LIndexUpdateFuture>();
        }
        this.indexUpdateFutures.add(future);
    }

    @Override
    public void waitForIndexUpdates() {
        if (this.indexUpdateFutures != null) {
            try {
                for (LIndexUpdateFuture f : this.indexUpdateFutures) {
                    f.get();
                }
            }
            catch (InterruptedException e) {
                throw new PersistenceLuceneException(e);
            }
            catch (ExecutionException e) {
                throw new PersistenceLuceneException(e);
            }
        }
    }

    @Override
    public void registerDeleteBean(Integer persistingBean) {
        if (this.deletingBeansHash == null) {
            this.deletingBeansHash = new HashSet();
        }
        this.deletingBeansHash.add(persistingBean);
    }

    @Override
    public void unregisterDeleteBean(Integer persistedBean) {
        if (this.deletingBeansHash != null) {
            this.deletingBeansHash.remove(persistedBean);
        }
    }

    @Override
    public boolean isRegisteredDeleteBean(Integer persistingBean) {
        if (this.deletingBeansHash == null) {
            return false;
        }
        return this.deletingBeansHash.contains(persistingBean);
    }

    @Override
    public void unregisterBean(Object bean) {
        this.persistingBeans.remove(bean);
    }

    @Override
    public boolean isRegisteredBean(Object bean) {
        return !this.persistingBeans.add(bean);
    }

    @Override
    public int depth(int diff) {
        this.depth += diff;
        return this.depth;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            return this.connection.isReadOnly();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            this.localReadOnly = readOnly;
            this.connection.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @Override
    public void setBatchMode(boolean batchMode) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.batchMode = batchMode;
    }

    @Override
    public void setBatchGetGeneratedKeys(boolean getGeneratedKeys) {
        this.batchGetGeneratedKeys = getGeneratedKeys;
        if (this.batchControl != null) {
            this.batchControl.setGetGeneratedKeys(getGeneratedKeys);
        }
    }

    @Override
    public void setBatchFlushOnMixed(boolean batchFlushOnMixed) {
        this.batchFlushOnMixed = batchFlushOnMixed;
        if (this.batchControl != null) {
            this.batchControl.setBatchFlushOnMixed(batchFlushOnMixed);
        }
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        if (this.batchControl != null) {
            this.batchControl.setBatchSize(batchSize);
        }
    }

    @Override
    public boolean isBatchFlushOnQuery() {
        return this.batchFlushOnQuery;
    }

    @Override
    public void setBatchFlushOnQuery(boolean batchFlushOnQuery) {
        this.batchFlushOnQuery = batchFlushOnQuery;
    }

    @Override
    public boolean isBatchThisRequest() {
        if (!this.explicit && this.depth <= 0) {
            return false;
        }
        return this.batchMode;
    }

    @Override
    public BatchControl getBatchControl() {
        return this.batchControl;
    }

    @Override
    public void setBatchControl(BatchControl batchControl) {
        this.queryOnly = false;
        this.batchControl = batchControl;
        if (this.batchGetGeneratedKeys != null) {
            batchControl.setGetGeneratedKeys(this.batchGetGeneratedKeys);
        }
        if (this.batchSize != -1) {
            batchControl.setBatchSize(this.batchSize);
        }
        if (this.batchFlushOnMixed != null) {
            batchControl.setBatchFlushOnMixed(this.batchFlushOnMixed);
        }
    }

    @Override
    public void flushBatch() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        if (this.batchControl != null) {
            this.batchControl.flush();
        }
    }

    @Override
    public void batchFlush() {
        this.flushBatch();
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void setPersistenceContext(PersistenceContext context) {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        this.persistenceContext = context;
    }

    @Override
    public TransactionEvent getEvent() {
        this.queryOnly = false;
        if (this.event == null) {
            this.event = new TransactionEvent();
        }
        return this.event;
    }

    @Override
    public void setLoggingOn(boolean loggingOn) {
        this.logLevel = loggingOn ? LogLevel.SQL : LogLevel.NONE;
    }

    @Override
    public boolean isExplicit() {
        return this.explicit;
    }

    @Override
    public boolean isLogSql() {
        return this.logLevel.ordinal() >= LogLevel.SQL.ordinal();
    }

    @Override
    public boolean isLogSummary() {
        return this.logLevel.ordinal() >= LogLevel.SUMMARY.ordinal();
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void log(String msg) {
        if (this.isLogSummary()) {
            this.logInternal(msg);
        }
    }

    @Override
    public void logInternal(String msg) {
        if (this.manager != null && this.logBuffer.add(msg)) {
            this.manager.log(this.logBuffer);
            this.logBuffer = this.logBuffer.newBuffer();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Connection getInternalConnection() {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        return this.connection;
    }

    @Override
    public Connection getConnection() {
        this.queryOnly = false;
        return this.getInternalConnection();
    }

    protected void deactivate() {
        try {
            if (this.localReadOnly) {
                this.connection.setReadOnly(false);
            }
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Error setting to readOnly?", e);
        }
        try {
            this.connection.close();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error closing connection", ex);
        }
        this.connection = null;
        this.active = false;
    }

    @Override
    public TransactionLogBuffer getLogBuffer() {
        return this.logBuffer;
    }

    protected void notifyCommit() {
        if (this.manager == null) {
            return;
        }
        if (this.queryOnly) {
            this.manager.notifyOfQueryOnly(true, this, null);
        } else {
            this.manager.notifyOfCommit(this);
        }
    }

    private void commitQueryOnly() {
        try {
            switch (this.onQueryOnly) {
                case ROLLBACK: {
                    this.connection.rollback();
                    break;
                }
                case COMMIT: {
                    this.connection.commit();
                    break;
                }
                case CLOSE_ON_READCOMMITTED: {
                    break;
                }
                default: {
                    this.connection.rollback();
                    break;
                }
            }
        }
        catch (SQLException e) {
            String m = "Error when ending a query only transaction via " + (Object)((Object)this.onQueryOnly);
            logger.log(Level.SEVERE, m, e);
        }
    }

    @Override
    public void commit() throws RollbackException {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            if (this.queryOnly) {
                this.commitQueryOnly();
            } else {
                if (this.batchControl != null && !this.batchControl.isEmpty()) {
                    this.batchControl.flush();
                }
                this.connection.commit();
            }
            this.deactivate();
            this.notifyCommit();
        }
        catch (Exception e) {
            throw new RollbackException((Throwable)e);
        }
    }

    protected void notifyRollback(Throwable cause) {
        if (this.manager == null) {
            return;
        }
        if (this.queryOnly) {
            this.manager.notifyOfQueryOnly(false, this, cause);
        } else {
            this.manager.notifyOfRollback(this, cause);
        }
    }

    @Override
    public void rollback() throws PersistenceException {
        this.rollback(null);
    }

    @Override
    public void rollback(Throwable cause) throws PersistenceException {
        if (!this.isActive()) {
            throw new IllegalStateException(illegalStateMessage);
        }
        try {
            this.connection.rollback();
            this.deactivate();
            this.notifyRollback(cause);
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    @Override
    public void end() throws PersistenceException {
        if (this.isActive()) {
            this.rollback();
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isPersistCascade() {
        return this.persistCascade;
    }

    @Override
    public void setPersistCascade(boolean persistCascade) {
        this.persistCascade = persistCascade;
    }

    @Override
    public void addModification(String tableName, boolean inserts, boolean updates, boolean deletes) {
        this.getEvent().add(tableName, inserts, updates, deletes);
    }

    public final TransactionManager getTransactionManger() {
        return this.manager;
    }
}

