/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.ldap.expression;

import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiLuceneExpr;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.ldap.expression.LdAbstractExpression;
import com.avaje.ebeaninternal.server.query.LuceneResolvableRequest;
import com.avaje.ebeaninternal.server.type.ScalarType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LdSimpleExpression
extends LdAbstractExpression {
    private static final long serialVersionUID = 4091359751840929075L;
    private final Op type;
    private final Object value;

    public LdSimpleExpression(String propertyName, Op type, Object value) {
        super(propertyName);
        this.type = type;
        this.value = value;
    }

    @Override
    public boolean isLuceneResolvable(LuceneResolvableRequest req) {
        return false;
    }

    @Override
    public SpiLuceneExpr createLuceneExpr(SpiExpressionRequest request) {
        return null;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                Object[] ids = prop.getAssocOneIdValues(this.value);
                if (ids != null) {
                    for (int i = 0; i < ids.length; ++i) {
                        request.addBindValue(ids[i]);
                    }
                }
                return;
            }
            ScalarType<?> scalarType = prop.getBeanProperty().getScalarType();
            Object v = scalarType.toJdbcType(this.value);
            request.addBindValue(v);
        } else {
            request.addBindValue(this.value);
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isAssocId()) {
            String rawExpr = prop.getAssocOneIdExpr(this.propertyName, this.type.toString());
            String parsed = request.parseDeploy(rawExpr);
            request.append(parsed);
            return;
        }
        String parsed = request.parseDeploy(this.propertyName);
        request.append("(").append(parsed).append("").append(this.type.toString()).append(this.nextParam(request)).append(")");
    }

    @Override
    public int queryAutoFetchHash() {
        int hc = LdSimpleExpression.class.getName().hashCode();
        hc = hc * 31 + this.propertyName.hashCode();
        hc = hc * 31 + this.type.name().hashCode();
        return hc;
    }

    @Override
    public int queryPlanHash(BeanQueryRequest<?> request) {
        return this.queryAutoFetchHash();
    }

    @Override
    public int queryBindHash() {
        return this.value.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Op {
        EQ{

            public String toString() {
                return "=";
            }
        }
        ,
        NOT_EQ{

            public String toString() {
                return "<>";
            }
        }
        ,
        LT{

            public String toString() {
                return "<";
            }
        }
        ,
        LT_EQ{

            public String toString() {
                return "<=";
            }
        }
        ,
        GT{

            public String toString() {
                return ">";
            }
        }
        ,
        GT_EQ{

            public String toString() {
                return ">=";
            }
        };

    }
}

