/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.error.ShouldBeEqualWithinOffset;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Numbers;
import org.assertj.core.util.VisibleForTesting;

public class Longs
extends Numbers<Long> {
    private static final Longs INSTANCE = new Longs();

    public static Longs instance() {
        return INSTANCE;
    }

    @Override
    protected Long zero() {
        return 0L;
    }

    @VisibleForTesting
    Longs() {
    }

    public Longs(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    public void assertIsCloseTo(AssertionInfo info, Long actual, Long expected, Offset<Long> offset) {
        Longs.assertNotNull(info, actual);
        CommonValidations.checkOffsetIsNotNull(offset);
        CommonValidations.checkNumberIsNotNull(expected);
        long absDiff = Math.abs(expected - actual);
        if (absDiff > (Long)offset.value) {
            throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset, absDiff));
        }
    }
}

