/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.SoftProxies;
import org.assertj.core.internal.cglib.proxy.MethodInterceptor;
import org.assertj.core.internal.cglib.proxy.MethodProxy;
import org.assertj.core.util.Preconditions;

class ProxifyExtractingResult
implements MethodInterceptor {
    private final SoftProxies proxies;

    ProxifyExtractingResult(SoftProxies proxies) {
        this.proxies = proxies;
    }

    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = proxy.invokeSuper(obj, args);
        return this.proxies.create(result.getClass(), ProxifyExtractingResult.actualClass(result), ProxifyExtractingResult.actual(result));
    }

    private static Class actualClass(Object result) {
        if (result instanceof ObjectArrayAssert) {
            return Array.newInstance(Object.class, 0).getClass();
        }
        Type actualType = ((ParameterizedType)result.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        if (actualType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)actualType).getRawType();
        }
        return (Class)actualType;
    }

    private static Object actual(Object result) {
        Preconditions.checkState(result instanceof AbstractAssert, "We should be trying to make a proxy of an *Assert class.", new Object[0]);
        return ((AbstractAssert)result).actual;
    }
}

