/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Throwables;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractThrowableAssert<SELF extends AbstractThrowableAssert<SELF, ACTUAL>, ACTUAL extends Throwable>
extends AbstractObjectAssert<SELF, ACTUAL> {
    @VisibleForTesting
    Throwables throwables = Throwables.instance();

    public AbstractThrowableAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    protected SELF hasBeenThrown() {
        if (this.actual == null) {
            throw Failures.instance().failure("Expecting code to raise a throwable.");
        }
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessage(String message) {
        this.throwables.assertHasMessage(this.info, (Throwable)this.actual, message);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessage(String message, Object ... parameters) {
        return this.hasMessage(String.format(message, parameters));
    }

    public SELF hasCause(Throwable cause) {
        this.throwables.assertHasCause(this.info, (Throwable)this.actual, cause);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasNoCause() {
        this.throwables.assertHasNoCause(this.info, (Throwable)this.actual);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageStartingWith(String description) {
        this.throwables.assertHasMessageStartingWith(this.info, (Throwable)this.actual, description);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageContaining(String description) {
        this.throwables.assertHasMessageContaining(this.info, (Throwable)this.actual, description);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasStackTraceContaining(String description) {
        this.throwables.assertHasStackTraceContaining(this.info, (Throwable)this.actual, description);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageMatching(String regex) {
        this.throwables.assertHasMessageMatching(this.info, (Throwable)this.actual, regex);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasMessageEndingWith(String description) {
        this.throwables.assertHasMessageEndingWith(this.info, (Throwable)this.actual, description);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasCauseInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasCauseInstanceOf(this.info, (Throwable)this.actual, type);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasCauseExactlyInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasCauseExactlyInstanceOf(this.info, (Throwable)this.actual, type);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasRootCauseInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasRootCauseInstanceOf(this.info, (Throwable)this.actual, type);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasRootCauseExactlyInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasRootCauseExactlyInstanceOf(this.info, (Throwable)this.actual, type);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasNoSuppressedExceptions() {
        this.throwables.assertHasNoSuppressedExceptions(this.info, (Throwable)this.actual);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }

    public SELF hasSuppressedException(Throwable suppressedException) {
        this.throwables.assertHasSuppressedException(this.info, (Throwable)this.actual, suppressedException);
        return (SELF)((AbstractThrowableAssert)this.myself);
    }
}

