/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.IntArrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractIntArrayAssert<SELF extends AbstractIntArrayAssert<SELF>>
extends AbstractArrayAssert<SELF, int[], Integer> {
    @VisibleForTesting
    protected IntArrays arrays = IntArrays.instance();

    public AbstractIntArrayAssert(int[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (int[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (int[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (int[])this.actual);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (int[])this.actual, expected);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (int[])this.actual, other);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF contains(int ... values) {
        this.arrays.assertContains(this.info, (int[])this.actual, values);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF containsOnly(int ... values) {
        this.arrays.assertContainsOnly(this.info, (int[])this.actual, values);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(int ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (int[])this.actual, values);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF containsSequence(int ... sequence) {
        this.arrays.assertContainsSequence(this.info, (int[])this.actual, sequence);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF containsSubsequence(int ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (int[])this.actual, subsequence);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF contains(int value, Index index) {
        this.arrays.assertContains(this.info, (int[])this.actual, value, index);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF doesNotContain(int ... values) {
        this.arrays.assertDoesNotContain(this.info, (int[])this.actual, values);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF doesNotContain(int value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (int[])this.actual, value, index);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (int[])this.actual);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF startsWith(int ... sequence) {
        this.arrays.assertStartsWith(this.info, (int[])this.actual, sequence);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF endsWith(int ... sequence) {
        this.arrays.assertEndsWith(this.info, (int[])this.actual, sequence);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (int[])this.actual);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super Integer> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (int[])this.actual, comparator);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super Integer> customComparator) {
        this.arrays = new IntArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = IntArrays.instance();
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF containsExactly(int ... values) {
        this.arrays.assertContainsExactly(this.info, (int[])this.actual, values);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(int ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (int[])this.actual, values);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }

    public SELF containsAnyOf(int ... values) {
        this.arrays.assertContainsAnyOf(this.info, (int[])this.actual, values);
        return (SELF)((AbstractIntArrayAssert)this.myself);
    }
}

