/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.web.support.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.servlet.HandlerInterceptor;

public class InMemoryThrottledSubmissionCleaner
implements Runnable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryThrottledSubmissionCleaner.class);
    private final AuthenticationThrottlingExecutionPlan authenticationThrottlingExecutionPlan;

    @Override
    @Scheduled(initialDelayString="${cas.authn.throttle.schedule.startDelay:PT10S}", fixedDelayString="${cas.authn.throttle.schedule.repeatInterval:PT15S}")
    public void run() {
        List<HandlerInterceptor> handlers = this.authenticationThrottlingExecutionPlan.getAuthenticationThrottleInterceptors();
        handlers.stream().filter(handler -> handler instanceof ThrottledSubmissionHandlerInterceptor).map(handler -> (ThrottledSubmissionHandlerInterceptor)handler).forEach(ThrottledSubmissionHandlerInterceptor::decrement);
    }

    @Generated
    public InMemoryThrottledSubmissionCleaner(AuthenticationThrottlingExecutionPlan authenticationThrottlingExecutionPlan) {
        this.authenticationThrottlingExecutionPlan = authenticationThrottlingExecutionPlan;
    }
}

