/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.web.support.ThrottledSubmissionHandlerInterceptor;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class AbstractThrottledSubmissionHandlerInterceptorAdapter
extends HandlerInterceptorAdapter
implements ThrottledSubmissionHandlerInterceptor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractThrottledSubmissionHandlerInterceptorAdapter.class);
    public static final String ACTION_THROTTLED_LOGIN_ATTEMPT = "THROTTLED_LOGIN_ATTEMPT";
    private static final double NUMBER_OF_MILLISECONDS_IN_SECOND = 1000.0;
    private final int failureThreshold;
    private final int failureRangeInSeconds;
    private final String usernameParameter;
    private double thresholdRate = -1.0;
    private final String authenticationFailureCode;
    private final AuditTrailExecutionPlan auditTrailExecutionPlan;
    private final String applicationCode;

    @PostConstruct
    public void afterPropertiesSet() {
        this.thresholdRate = (double)this.failureThreshold / (double)this.failureRangeInSeconds;
        LOGGER.debug("Calculated threshold rate as [{}]", (Object)this.thresholdRate);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        if (!HttpMethod.POST.name().equals(request.getMethod())) {
            return true;
        }
        if (this.exceedsThreshold(request)) {
            this.recordThrottle(request);
            request.setAttribute("CAS_ACCESS_DENIED_REASON", (Object)"screen.blocked.message");
            response.sendError(423, "Access Denied for user [" + StringEscapeUtils.escapeHtml4((String)request.getParameter(this.usernameParameter)) + "] from IP Address [" + request.getRemoteAddr() + ']');
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) {
        if (!HttpMethod.POST.name().equals(request.getMethod())) {
            LOGGER.trace("Skipping authentication throttling for requests other than POST");
            return;
        }
        boolean recordEvent = this.shouldResponseBeRecordedAsFailure(response);
        if (recordEvent) {
            LOGGER.debug("Recording submission failure for [{}]", (Object)request.getRequestURI());
            this.recordSubmissionFailure(request);
        } else {
            LOGGER.trace("Skipping to record submission failure for [{}] with response status [{}]", (Object)request.getRequestURI(), (Object)response.getStatus());
        }
    }

    protected boolean shouldResponseBeRecordedAsFailure(HttpServletResponse response) {
        int status = response.getStatus();
        return status != 201 && status != 200 && status != 302;
    }

    protected void recordThrottle(HttpServletRequest request) {
        LOGGER.warn("Throttling submission from [{}]. More than [{}] failed login attempts within [{}] seconds. Authentication attempt exceeds the failure threshold [{}]", new Object[]{request.getRemoteAddr(), this.failureThreshold, this.failureRangeInSeconds, this.failureThreshold});
    }

    public void decrement() {
        LOGGER.debug("Throttling is not activated for this interceptor adapter");
    }

    protected boolean calculateFailureThresholdRateAndCompare(List<Date> failures) {
        if (failures.size() < 2) {
            return false;
        }
        long lastTime = failures.get(0).getTime();
        long secondToLastTime = failures.get(1).getTime();
        long difference = lastTime - secondToLastTime;
        double rate = 1000.0 / (double)difference;
        LOGGER.debug("Last attempt was at [{}] and the one before that was at [{}]. Difference is [{}] calculated as rate of [{}]", new Object[]{lastTime, secondToLastTime, difference, rate});
        if (rate > this.getThresholdRate()) {
            LOGGER.warn("Authentication throttling rate [{}] exceeds the defined threshold [{}]", (Object)rate, (Object)this.getThresholdRate());
            return true;
        }
        return false;
    }

    protected String getUsernameParameterFromRequest(HttpServletRequest request) {
        return request.getParameter(StringUtils.defaultString((String)this.usernameParameter, (String)"username"));
    }

    protected Date getFailureInRangeCutOffDate() {
        ZonedDateTime cutoff = ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(this.getFailureRangeInSeconds());
        return DateTimeUtils.timestampOf((ChronoZonedDateTime)cutoff);
    }

    protected void recordAuditAction(HttpServletRequest request, String actionName) {
        String userToUse = this.getUsernameParameterFromRequest(request);
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        String resource = StringUtils.defaultString((String)request.getParameter("service"), (String)"N/A");
        AuditActionContext context = new AuditActionContext(userToUse, resource, actionName, this.applicationCode, DateTimeUtils.dateOf((ChronoZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC)), clientInfo.getClientIpAddress(), clientInfo.getServerIpAddress());
        LOGGER.debug("Recording throttled audit action [{}}", (Object)context);
        this.auditTrailExecutionPlan.record(context);
    }

    @Generated
    public String toString() {
        return "AbstractThrottledSubmissionHandlerInterceptorAdapter(failureThreshold=" + this.failureThreshold + ", failureRangeInSeconds=" + this.failureRangeInSeconds + ", usernameParameter=" + this.usernameParameter + ", thresholdRate=" + this.thresholdRate + ", authenticationFailureCode=" + this.authenticationFailureCode + ", auditTrailExecutionPlan=" + this.auditTrailExecutionPlan + ", applicationCode=" + this.applicationCode + ")";
    }

    @Generated
    public int getFailureThreshold() {
        return this.failureThreshold;
    }

    @Generated
    public int getFailureRangeInSeconds() {
        return this.failureRangeInSeconds;
    }

    @Generated
    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    @Generated
    public double getThresholdRate() {
        return this.thresholdRate;
    }

    @Generated
    public String getAuthenticationFailureCode() {
        return this.authenticationFailureCode;
    }

    @Generated
    public AuditTrailExecutionPlan getAuditTrailExecutionPlan() {
        return this.auditTrailExecutionPlan;
    }

    @Generated
    public String getApplicationCode() {
        return this.applicationCode;
    }

    @Generated
    public AbstractThrottledSubmissionHandlerInterceptorAdapter(int failureThreshold, int failureRangeInSeconds, String usernameParameter, String authenticationFailureCode, AuditTrailExecutionPlan auditTrailExecutionPlan, String applicationCode) {
        this.failureThreshold = failureThreshold;
        this.failureRangeInSeconds = failureRangeInSeconds;
        this.usernameParameter = usernameParameter;
        this.authenticationFailureCode = authenticationFailureCode;
        this.auditTrailExecutionPlan = auditTrailExecutionPlan;
        this.applicationCode = applicationCode;
    }
}

