/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.apereo.cas.web.support.InMemoryThrottledSubmissionHandlerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter
implements InMemoryThrottledSubmissionHandlerInterceptor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter.class);
    private static final double SUBMISSION_RATE_DIVIDEND = 1000.0;
    private final ConcurrentMap<String, ZonedDateTime> ipMap = new ConcurrentHashMap<String, ZonedDateTime>();

    public AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter(int failureThreshold, int failureRangeInSeconds, String usernameParameter, String authenticationFailureCode, AuditTrailExecutionPlan auditTrailExecutionPlan, String applicationCode) {
        super(failureThreshold, failureRangeInSeconds, usernameParameter, authenticationFailureCode, auditTrailExecutionPlan, applicationCode);
    }

    public boolean exceedsThreshold(HttpServletRequest request) {
        ZonedDateTime last = (ZonedDateTime)this.ipMap.get(this.constructKey(request));
        return last != null && AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter.submissionRate(ZonedDateTime.now(ZoneOffset.UTC), last) > this.getThresholdRate();
    }

    public void recordSubmissionFailure(HttpServletRequest request) {
        this.ipMap.put(this.constructKey(request), ZonedDateTime.now(ZoneOffset.UTC));
    }

    @Override
    public void decrement() {
        LOGGER.info("Beginning audit cleanup...");
        Set keys = this.ipMap.entrySet();
        LOGGER.debug("Decrementing counts for throttler.  Starting key count: [{}]", (Object)keys.size());
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(AbstractInMemoryThrottledSubmissionHandlerInterceptorAdapter.submissionRate(now, (ZonedDateTime)entry.getValue()) < this.getThresholdRate())) continue;
            LOGGER.trace("Removing entry for key [{}]", entry.getKey());
            iter.remove();
        }
        LOGGER.debug("Done decrementing count for throttler.");
    }

    private static double submissionRate(ZonedDateTime a, ZonedDateTime b) {
        return 1000.0 / (double)(a.toInstant().toEpochMilli() - b.toInstant().toEpochMilli());
    }
}

