/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.code;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.HashSet;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.AbstractTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="OAUTH_TOKENS")
@DiscriminatorColumn(name="TYPE")
@DiscriminatorValue(value="OC")
public class OAuthCodeImpl
extends AbstractTicket
implements OAuthCode {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthCodeImpl.class);
    private static final long serialVersionUID = -8072724186202305800L;
    @Lob
    @Column(name="scopes", length=0x7FFFFFFF)
    private HashSet<String> scopes = new HashSet();
    @ManyToOne(targetEntity=TicketGrantingTicketImpl.class)
    @JsonProperty(value="ticketGrantingTicket")
    private TicketGrantingTicket ticketGrantingTicket;
    @Lob
    @Column(name="SERVICE", nullable=false)
    private Service service;
    @Lob
    @Column(name="AUTHENTICATION", nullable=false, length=0x7FFFFFFF)
    private Authentication authentication;

    public OAuthCodeImpl(String id, @NonNull Service service, @NonNull Authentication authentication, ExpirationPolicy expirationPolicy, TicketGrantingTicket ticketGrantingTicket, Collection<String> scopes) {
        super(id, expirationPolicy);
        if (service == null) {
            throw new NullPointerException("service is marked @NonNull but is null");
        }
        if (authentication == null) {
            throw new NullPointerException("authentication is marked @NonNull but is null");
        }
        this.service = service;
        this.authentication = authentication;
        this.ticketGrantingTicket = ticketGrantingTicket;
        this.scopes.addAll(scopes);
    }

    public boolean isFromNewLogin() {
        return true;
    }

    public Service getService() {
        return this.service;
    }

    public boolean isValidFor(Service serviceToValidate) {
        this.update();
        return serviceToValidate.matches(this.service);
    }

    public ProxyGrantingTicket grantProxyGrantingTicket(String id, Authentication authentication, ExpirationPolicy expirationPolicy) {
        throw new UnsupportedOperationException("No PGT grant is available in OAuth");
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public TicketGrantingTicket getTicketGrantingTicket() {
        return this.ticketGrantingTicket;
    }

    public String getPrefix() {
        return "OC";
    }

    public Collection<String> getScopes() {
        return (Collection)ObjectUtils.defaultIfNull(this.scopes, new HashSet());
    }

    @Generated
    public OAuthCodeImpl() {
    }
}

