/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.accesstoken.AccessTokenImpl;
import org.apereo.cas.ticket.code.OAuthCodeImpl;
import org.apereo.cas.ticket.refreshtoken.RefreshTokenImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(value="oauthProtocolTicketMetadataRegistrationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class OAuthProtocolTicketCatalogConfiguration
extends BaseTicketCatalogConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthProtocolTicketCatalogConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    public void configureTicketCatalog(TicketCatalog plan) {
        LOGGER.debug("Registering core OAuth protocol ticket definitions...");
        this.buildAndRegisterOAuthCodeDefinition(plan, this.buildTicketDefinition(plan, "OC", OAuthCodeImpl.class));
        this.buildAndRegisterAccessTokenDefinition(plan, this.buildTicketDefinition(plan, "AT", AccessTokenImpl.class));
        this.buildAndRegisterRefreshTokenDefinition(plan, this.buildTicketDefinition(plan, "RT", RefreshTokenImpl.class));
    }

    protected void buildAndRegisterAccessTokenDefinition(TicketCatalog plan, TicketDefinition metadata) {
        metadata.getProperties().setStorageName("oauthAccessTokensCache");
        long timeout = Beans.newDuration((String)this.casProperties.getAuthn().getOauth().getAccessToken().getMaxTimeToLiveInSeconds()).getSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterRefreshTokenDefinition(TicketCatalog plan, TicketDefinition metadata) {
        metadata.getProperties().setStorageName("oauthRefreshTokensCache");
        long timeout = Beans.newDuration((String)this.casProperties.getAuthn().getOauth().getRefreshToken().getTimeToKillInSeconds()).getSeconds();
        metadata.getProperties().setStorageTimeout(timeout);
        this.registerTicketDefinition(plan, metadata);
    }

    protected void buildAndRegisterOAuthCodeDefinition(TicketCatalog plan, TicketDefinition metadata) {
        metadata.getProperties().setStorageName("oauthCodesCache");
        metadata.getProperties().setStorageTimeout(this.casProperties.getAuthn().getOauth().getCode().getTimeToKillInSeconds());
        this.registerTicketDefinition(plan, metadata);
    }
}

