/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.apereo.cas.ticket.TicketState;
import org.apereo.cas.ticket.support.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class OAuthRefreshTokenExpirationPolicy
extends AbstractCasExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuthRefreshTokenExpirationPolicy.class);
    private static final long serialVersionUID = -7144233906843566234L;
    private long timeToKillInSeconds;

    @JsonCreator
    public OAuthRefreshTokenExpirationPolicy(@JsonProperty(value="timeToLive") long timeToKillInSeconds) {
        this.timeToKillInSeconds = timeToKillInSeconds;
    }

    public boolean isExpired(TicketState ticketState) {
        boolean expired = this.isRefreshTokenExpired(ticketState);
        if (!expired) {
            return super.isExpired(ticketState);
        }
        return expired;
    }

    public Long getTimeToLive() {
        return this.timeToKillInSeconds;
    }

    @JsonIgnore
    public Long getTimeToIdle() {
        return 0L;
    }

    @JsonIgnore
    protected boolean isRefreshTokenExpired(TicketState ticketState) {
        ZonedDateTime expiringTime = ticketState.getCreationTime().plus(this.timeToKillInSeconds, ChronoUnit.SECONDS);
        return ticketState == null || expiringTime.isBefore(ZonedDateTime.now(ZoneOffset.UTC));
    }

    @Generated
    public OAuthRefreshTokenExpirationPolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthRefreshTokenExpirationPolicy)) {
            return false;
        }
        OAuthRefreshTokenExpirationPolicy other = (OAuthRefreshTokenExpirationPolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.timeToKillInSeconds == other.timeToKillInSeconds;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuthRefreshTokenExpirationPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $timeToKillInSeconds = this.timeToKillInSeconds;
        result = result * 59 + (int)($timeToKillInSeconds >>> 32 ^ $timeToKillInSeconds);
        return result;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
    public static class OAuthRefreshTokenSovereignExpirationPolicy
    extends OAuthRefreshTokenExpirationPolicy {
        @Generated
        private static final Logger LOGGER = LoggerFactory.getLogger(OAuthRefreshTokenSovereignExpirationPolicy.class);
        private static final long serialVersionUID = -7768661082888351104L;

        @JsonCreator
        public OAuthRefreshTokenSovereignExpirationPolicy(@JsonProperty(value="timeToLive") long timeToKillInSeconds) {
            super(timeToKillInSeconds);
        }

        @Override
        public boolean isExpired(TicketState ticketState) {
            return this.isRefreshTokenExpired(ticketState);
        }

        @Generated
        public OAuthRefreshTokenSovereignExpirationPolicy() {
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OAuthRefreshTokenSovereignExpirationPolicy)) {
                return false;
            }
            OAuthRefreshTokenSovereignExpirationPolicy other = (OAuthRefreshTokenSovereignExpirationPolicy)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OAuthRefreshTokenSovereignExpirationPolicy;
        }

        @Override
        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

