/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.code;

import java.util.Collection;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketFactory;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.code.OAuthCodeFactory;
import org.apereo.cas.ticket.code.OAuthCodeImpl;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOAuthCodeFactory
implements OAuthCodeFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuthCodeFactory.class);
    protected final UniqueTicketIdGenerator oAuthCodeIdGenerator;
    protected final ExpirationPolicy expirationPolicy;

    public DefaultOAuthCodeFactory(ExpirationPolicy expirationPolicy) {
        this((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator(), expirationPolicy);
    }

    @Override
    public OAuthCode create(Service service, Authentication authentication, TicketGrantingTicket ticketGrantingTicket, Collection<String> scopes) {
        String codeId = this.oAuthCodeIdGenerator.getNewTicketId("OC");
        return new OAuthCodeImpl(codeId, service, authentication, this.expirationPolicy, ticketGrantingTicket, scopes);
    }

    public TicketFactory get(Class<? extends Ticket> clazz) {
        return this;
    }

    @Generated
    public DefaultOAuthCodeFactory(UniqueTicketIdGenerator oAuthCodeIdGenerator, ExpirationPolicy expirationPolicy) {
        this.oAuthCodeIdGenerator = oAuthCodeIdGenerator;
        this.expirationPolicy = expirationPolicy;
    }
}

