/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.AccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationResponseBuilder;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.View;

public class OAuth20ResourceOwnerCredentialsResponseBuilder
implements OAuth20AuthorizationResponseBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ResourceOwnerCredentialsResponseBuilder.class);
    private final AccessTokenResponseGenerator accessTokenResponseGenerator;
    private final OAuth20TokenGenerator accessTokenGenerator;
    private final ExpirationPolicy accessTokenExpirationPolicy;

    @Override
    public View build(J2EContext context, String clientId, AccessTokenRequestDataHolder holder) {
        Pair<AccessToken, RefreshToken> accessToken = this.accessTokenGenerator.generate(holder);
        this.accessTokenResponseGenerator.generate(context.getRequest(), context.getResponse(), holder.getRegisteredService(), holder.getService(), (AccessToken)accessToken.getKey(), (RefreshToken)accessToken.getValue(), this.accessTokenExpirationPolicy.getTimeToLive(), OAuth20Utils.getResponseType(context));
        return null;
    }

    @Override
    public boolean supports(J2EContext context) {
        String grantType = context.getRequestParameter("grant_type");
        return OAuth20Utils.isGrantType(grantType, OAuth20GrantTypes.PASSWORD);
    }

    @Generated
    public OAuth20ResourceOwnerCredentialsResponseBuilder(AccessTokenResponseGenerator accessTokenResponseGenerator, OAuth20TokenGenerator accessTokenGenerator, ExpirationPolicy accessTokenExpirationPolicy) {
        this.accessTokenResponseGenerator = accessTokenResponseGenerator;
        this.accessTokenGenerator = accessTokenGenerator;
        this.accessTokenExpirationPolicy = accessTokenExpirationPolicy;
    }
}

