/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.AccessTokenResponseGenerator;
import org.apereo.cas.ticket.accesstoken.AccessToken;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;

public class OAuth20AccessTokenResponseGenerator
implements AccessTokenResponseGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AccessTokenResponseGenerator.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory((ObjectCodec)new ObjectMapper().findAndRegisterModules());
    @Autowired
    protected ResourceLoader resourceLoader;
    @Autowired
    protected CasConfigurationProperties casProperties;

    @Override
    public void generate(HttpServletRequest request, HttpServletResponse response, OAuthRegisteredService registeredService, Service service, AccessToken accessTokenId, RefreshToken refreshTokenId, long timeout, OAuth20ResponseTypes responseType) {
        block15: {
            if (registeredService.isJsonFormat()) {
                response.setContentType("application/json");
                try (JsonGenerator jsonGenerator = this.getResponseJsonGenerator(response);){
                    jsonGenerator.writeStartObject();
                    this.generateJsonInternal(request, response, jsonGenerator, accessTokenId, refreshTokenId, timeout, service, registeredService, responseType);
                    jsonGenerator.writeEndObject();
                    break block15;
                }
            }
            this.generateTextInternal(request, response, accessTokenId, refreshTokenId, timeout);
        }
    }

    protected JsonGenerator getResponseJsonGenerator(HttpServletResponse response) throws IOException {
        return JSON_FACTORY.createGenerator((Writer)response.getWriter());
    }

    protected void generateTextInternal(HttpServletRequest request, HttpServletResponse response, AccessToken accessTokenId, RefreshToken refreshTokenId, long timeout) {
        StringBuilder builder = new StringBuilder(String.format("%s=%s&%s=%s", "access_token", accessTokenId.getId(), "expires_in", timeout));
        if (refreshTokenId != null) {
            builder.append('&').append("refresh_token").append('=').append(refreshTokenId.getId());
        }
        OAuth20Utils.writeText(response, builder.toString(), 200);
    }

    protected void generateJsonInternal(HttpServletRequest request, HttpServletResponse response, JsonGenerator jsonGenerator, AccessToken accessTokenId, RefreshToken refreshTokenId, long timeout, Service service, OAuthRegisteredService registeredService, OAuth20ResponseTypes responseType) throws Exception {
        jsonGenerator.writeStringField("access_token", accessTokenId.getId());
        jsonGenerator.writeStringField("token_type", "bearer");
        jsonGenerator.writeNumberField("expires_in", timeout);
        if (refreshTokenId != null) {
            jsonGenerator.writeStringField("refresh_token", refreshTokenId.getId());
        }
    }
}

