/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.validator.token.BaseOAuth20TokenRequestValidator;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.refreshtoken.RefreshToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.HttpRequestUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20RefreshTokenGrantTypeTokenRequestValidator
extends BaseOAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20RefreshTokenGrantTypeTokenRequestValidator.class);
    private final TicketRegistry ticketRegistry;

    public OAuth20RefreshTokenGrantTypeTokenRequestValidator(AuditableExecution registeredServiceAccessStrategyEnforcer, TicketRegistry ticketRegistry) {
        super(registeredServiceAccessStrategyEnforcer);
        this.ticketRegistry = ticketRegistry;
    }

    @Override
    protected OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.REFRESH_TOKEN;
    }

    @Override
    protected boolean validateInternal(J2EContext context, String grantType, ProfileManager manager, UserProfile uProfile) {
        HttpServletRequest request = context.getRequest();
        if (!(HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"refresh_token") && HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"client_id") && HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"client_secret"))) {
            return false;
        }
        String token = request.getParameter("refresh_token");
        Ticket refreshToken = this.ticketRegistry.getTicket(token);
        if (refreshToken == null) {
            LOGGER.warn("Provided refresh token [{}] cannot be found in the registry", (Object)token);
            return false;
        }
        if (!RefreshToken.class.isAssignableFrom(refreshToken.getClass())) {
            LOGGER.warn("Provided refresh token [{}] is found in the registry but its type is not classified as a refresh token", (Object)token);
            return false;
        }
        if (refreshToken.isExpired()) {
            LOGGER.warn("Provided refresh token [{}] has expired and is no longer valid.", (Object)token);
            return false;
        }
        return true;
    }
}

