/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.BaseOAuth20TokenRequestValidator;
import org.apereo.cas.ticket.OAuthToken;
import org.apereo.cas.ticket.code.OAuthCode;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.HttpRequestUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20AuthorizationCodeGrantTypeTokenRequestValidator
extends BaseOAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20AuthorizationCodeGrantTypeTokenRequestValidator.class);
    private final ServicesManager servicesManager;
    private final TicketRegistry ticketRegistry;

    public OAuth20AuthorizationCodeGrantTypeTokenRequestValidator(ServicesManager servicesManager, TicketRegistry ticketRegistry, AuditableExecution registeredServiceAccessStrategyEnforcer) {
        super(registeredServiceAccessStrategyEnforcer);
        this.servicesManager = servicesManager;
        this.ticketRegistry = ticketRegistry;
    }

    @Override
    protected OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.AUTHORIZATION_CODE;
    }

    @Override
    protected boolean validateInternal(J2EContext context, String grantType, ProfileManager manager, UserProfile uProfile) {
        boolean valid;
        HttpServletRequest request = context.getRequest();
        String clientId = uProfile.getId();
        String redirectUri = request.getParameter("redirect_uri");
        OAuthRegisteredService clientRegisteredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
        LOGGER.debug("Received grant type [{}] with client id [{}] and redirect URI [{}]", new Object[]{grantType, clientId, redirectUri});
        boolean bl = valid = HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"redirect_uri") && HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"code") && OAuth20Utils.checkCallbackValid((RegisteredService)clientRegisteredService, redirectUri);
        if (valid) {
            String code = context.getRequestParameter("code");
            OAuthToken token = (OAuthToken)this.ticketRegistry.getTicket(code, OAuthCode.class);
            if (token == null || token.isExpired()) {
                LOGGER.warn("Request OAuth code [{}] is not found or has expired", (Object)code);
                return false;
            }
            String id = token.getService().getId();
            OAuthRegisteredService codeRegisteredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, id);
            AuditableContext audit = AuditableContext.builder().service(token.getService()).authentication(token.getAuthentication()).registeredService((RegisteredService)codeRegisteredService).retrievePrincipalAttributesFromReleasePolicy(Boolean.TRUE).build();
            AuditableExecutionResult accessResult = this.registeredServiceAccessStrategyEnforcer.execute(audit);
            accessResult.throwExceptionIfNeeded();
            if (!clientRegisteredService.equals((Object)codeRegisteredService)) {
                LOGGER.warn("The OAuth code [{}] issued to service [{}] does not match the registered service [{}] provided in the request given the redirect URI [{}]", new Object[]{code, id, clientRegisteredService.getName(), redirectUri});
                return false;
            }
            return true;
        }
        LOGGER.warn("Access token request cannot be validated for grant type [{}} and client id [{}] given the redirect URI [{}]", new Object[]{grantType, clientId, redirectUri});
        return false;
    }
}

