/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.validator.token;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.token.OAuth20TokenRequestValidator;
import org.apereo.cas.util.Pac4jUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOAuth20TokenRequestValidator
implements OAuth20TokenRequestValidator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOAuth20TokenRequestValidator.class);
    protected final AuditableExecution registeredServiceAccessStrategyEnforcer;

    @Override
    public boolean validate(J2EContext context) {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        String grantType = request.getParameter("grant_type");
        if (!BaseOAuth20TokenRequestValidator.isGrantTypeSupported(grantType, OAuth20GrantTypes.values())) {
            LOGGER.warn("Grant type is not supported: [{}]", (Object)grantType);
            return false;
        }
        ProfileManager manager = Pac4jUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        Optional profile = manager.get(true);
        if (profile == null || !profile.isPresent()) {
            LOGGER.warn("Could not locate authenticated profile for this request");
            return false;
        }
        UserProfile uProfile = (UserProfile)profile.get();
        if (uProfile == null) {
            LOGGER.warn("Could not locate authenticated profile for this request as null");
            return false;
        }
        return this.validateInternal(context, grantType, manager, uProfile);
    }

    protected boolean validateInternal(J2EContext context, String grantType, ProfileManager manager, UserProfile userProfile) {
        return false;
    }

    protected abstract OAuth20GrantTypes getGrantType();

    @Override
    public boolean supports(J2EContext context) {
        String grantType = context.getRequestParameter("grant_type");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    private static boolean isGrantTypeSupported(String type, OAuth20GrantTypes ... expectedTypes) {
        LOGGER.debug("Grant type received: [{}]", (Object)type);
        for (OAuth20GrantTypes expectedType : expectedTypes) {
            if (!OAuth20Utils.isGrantType(type, expectedType)) continue;
            return true;
        }
        LOGGER.error("Unsupported grant type: [{}]", (Object)type);
        return false;
    }

    @Generated
    public BaseOAuth20TokenRequestValidator(AuditableExecution registeredServiceAccessStrategyEnforcer) {
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
    }
}

