/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.web.OAuth20HandlerInterceptorAdapter;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.web.support.AuthenticationThrottlingExecutionPlan;
import org.apereo.cas.web.support.AuthenticationThrottlingExecutionPlanConfigurer;
import org.pac4j.core.config.Config;
import org.pac4j.springframework.web.SecurityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Configuration(value="oauthThrottleConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasOAuthThrottleConfiguration
implements AuthenticationThrottlingExecutionPlanConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasOAuthThrottleConfiguration.class);
    @Autowired
    @Qualifier(value="oauthSecConfig")
    private ObjectProvider<Config> oauthSecConfig;
    @Autowired
    @Qualifier(value="accessTokenGrantRequestExtractors")
    private Collection<BaseAccessTokenGrantRequestExtractor> accessTokenGrantRequestExtractors;

    @ConditionalOnMissingBean(name={"requiresAuthenticationAuthorizeInterceptor"})
    @Bean
    public SecurityInterceptor requiresAuthenticationAuthorizeInterceptor() {
        return new SecurityInterceptor((Config)this.oauthSecConfig.getIfAvailable(), "CasOAuthClient");
    }

    @ConditionalOnMissingBean(name={"requiresAuthenticationAccessTokenInterceptor"})
    @Bean
    public SecurityInterceptor requiresAuthenticationAccessTokenInterceptor() {
        String clients = Stream.of("clientBasicAuth", "clientForm", "userForm").collect(Collectors.joining(","));
        return new SecurityInterceptor((Config)this.oauthSecConfig.getIfAvailable(), clients);
    }

    @ConditionalOnMissingBean(name={"oauthHandlerInterceptorAdapter"})
    @Bean
    public HandlerInterceptor oauthHandlerInterceptorAdapter() {
        return new OAuth20HandlerInterceptorAdapter((HandlerInterceptorAdapter)this.requiresAuthenticationAccessTokenInterceptor(), (HandlerInterceptorAdapter)this.requiresAuthenticationAuthorizeInterceptor(), this.accessTokenGrantRequestExtractors);
    }

    public void configureAuthenticationThrottlingExecutionPlan(AuthenticationThrottlingExecutionPlan plan) {
        plan.registerAuthenticationThrottleInterceptor(this.oauthHandlerInterceptorAdapter());
    }

    @Configuration(value="oauthThrottleWebMvcConfigurer")
    static class CasOAuthThrottleWebMvcConfigurer
    extends WebMvcConfigurerAdapter {
        @Autowired
        @Qualifier(value="authenticationThrottlingExecutionPlan")
        private AuthenticationThrottlingExecutionPlan authenticationThrottlingExecutionPlan;

        CasOAuthThrottleWebMvcConfigurer() {
        }

        public void addInterceptors(InterceptorRegistry registry) {
            this.authenticationThrottlingExecutionPlan.getAuthenticationThrottleInterceptors().forEach(handler -> registry.addInterceptor(handler).addPathPatterns(new String[]{"/oauth2.0".concat("/").concat("*")}));
        }
    }
}

