/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa.request;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.resolver.impl.mfa.request.BaseRequestMultifactorAuthenticationPolicyEventResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.CookieGenerator;

public class RequestHeaderMultifactorAuthenticationPolicyEventResolver
extends BaseRequestMultifactorAuthenticationPolicyEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHeaderMultifactorAuthenticationPolicyEventResolver.class);
    private final String mfaRequestHeader;

    public RequestHeaderMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationStrategies, MultifactorAuthenticationProviderSelector selector, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationStrategies, selector, casProperties);
        this.mfaRequestHeader = casProperties.getAuthn().getMfa().getRequestHeader();
    }

    @Override
    protected List<String> resolveEventFromHttpRequest(HttpServletRequest request) {
        Enumeration values = request.getHeaders(this.mfaRequestHeader);
        if (values != null) {
            LOGGER.debug("Received request header [{}] as [{}]", (Object)this.mfaRequestHeader, (Object)values);
            return Collections.list(values);
        }
        LOGGER.debug("No value could be found for request header [{}]", (Object)this.mfaRequestHeader);
        return null;
    }
}

