/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa.adaptive;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.format.TextStyle;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.TimeBasedAuthenticationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TimedMultifactorAuthenticationPolicyEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TimedMultifactorAuthenticationPolicyEventResolver.class);
    private final List<TimeBasedAuthenticationProperties> timedMultifactor;

    public TimedMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector, CasConfigurationProperties casProperties) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
        this.timedMultifactor = casProperties.getAuthn().getAdaptive().getRequireTimedMultifactor();
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        RegisteredService service = this.resolveRegisteredServiceInRequestContext(context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        if (service == null || authentication == null) {
            LOGGER.debug("No service or authentication is available to determine event for principal");
            return null;
        }
        if (this.timedMultifactor == null || this.timedMultifactor.isEmpty()) {
            LOGGER.debug("Adaptive authentication is not configured to require multifactor authentication by time");
            return null;
        }
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providerMap == null || providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context");
            throw new AuthenticationException();
        }
        Set<Event> providerFound = this.checkTimedMultifactorProvidersForRequest(context, service, authentication);
        if (providerFound != null && !providerFound.isEmpty()) {
            LOGGER.warn("Found multifactor authentication providers [{}] required for this authentication event", providerFound);
            return providerFound;
        }
        return null;
    }

    private Set<Event> checkTimedMultifactorProvidersForRequest(RequestContext context, RegisteredService service, Authentication authentication) {
        LocalDateTime now = LocalDateTime.now();
        DayOfWeek dow = DayOfWeek.from(now);
        List dayNamesForToday = Arrays.stream(TextStyle.values()).map(style -> dow.getDisplayName((TextStyle)((Object)style), Locale.getDefault())).collect(Collectors.toList());
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        TimeBasedAuthenticationProperties timed = this.timedMultifactor.stream().filter(t -> {
            boolean providerEvent = false;
            if (!t.getOnDays().isEmpty()) {
                providerEvent = t.getOnDays().stream().filter(dayNamesForToday::contains).findAny().isPresent();
            }
            if (t.getOnOrAfterHour() >= 0L) {
                boolean bl = providerEvent = (long)now.getHour() >= t.getOnOrAfterHour();
            }
            if (t.getOnOrBeforeHour() >= 0L) {
                providerEvent = (long)now.getHour() <= t.getOnOrBeforeHour();
            }
            return providerEvent;
        }).findFirst().orElse(null);
        if (timed != null) {
            Optional<MultifactorAuthenticationProvider> providerFound = this.resolveProvider((Map<String, MultifactorAuthenticationProvider>)providerMap, timed.getProviderId());
            if (!providerFound.isPresent()) {
                LOGGER.error("Adaptive authentication is configured to require [{}] for [{}], yet [{}] absent in the configuration.", new Object[]{timed.getProviderId(), service, timed.getProviderId()});
                throw new AuthenticationException();
            }
            return this.buildEvent(context, service, authentication, providerFound.get());
        }
        return null;
    }

    private Set<Event> buildEvent(RequestContext context, RegisteredService service, Authentication authentication, MultifactorAuthenticationProvider provider) {
        if (provider.isAvailable(service)) {
            LOGGER.debug("Attempting to build an event based on the authentication provider [{}] and service [{}]", (Object)provider, (Object)service.getName());
            Event event = this.validateEventIdForMatchingTransitionInContext(provider.getId(), context, TimedMultifactorAuthenticationPolicyEventResolver.buildEventAttributeMap(authentication.getPrincipal(), service, provider));
            return CollectionUtils.wrapSet((Object)event);
        }
        LOGGER.warn("Located multifactor provider [{}], yet the provider cannot be reached or verified", (Object)provider);
        return null;
    }

    @Override
    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }
}

