/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl.mfa.adaptive;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderSelector;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class AdaptiveMultifactorAuthenticationPolicyEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AdaptiveMultifactorAuthenticationPolicyEventResolver.class);
    private final GeoLocationService geoLocationService;
    private final Map<String, String> multifactorMap;

    public AdaptiveMultifactorAuthenticationPolicyEventResolver(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, CookieGenerator warnCookieGenerator, AuthenticationServiceSelectionPlan authenticationSelectionStrategies, MultifactorAuthenticationProviderSelector selector, CasConfigurationProperties casProperties, GeoLocationService geoLocationService) {
        super(authenticationSystemSupport, centralAuthenticationService, servicesManager, ticketRegistrySupport, warnCookieGenerator, authenticationSelectionStrategies, selector);
        this.multifactorMap = casProperties.getAuthn().getAdaptive().getRequireMultifactor();
        this.geoLocationService = geoLocationService;
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        RegisteredService service = this.resolveRegisteredServiceInRequestContext(context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        if (service == null || authentication == null) {
            LOGGER.debug("No service or authentication is available to determine event for principal");
            return null;
        }
        if (this.multifactorMap == null || this.multifactorMap.isEmpty()) {
            LOGGER.debug("Adaptive authentication is not configured to require multifactor authentication");
            return null;
        }
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        if (providerMap == null || providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context");
            throw new AuthenticationException();
        }
        Set<Event> providerFound = this.checkRequireMultifactorProvidersForRequest(context, service, authentication);
        if (providerFound != null && !providerFound.isEmpty()) {
            LOGGER.warn("Found multifactor authentication providers [{}] required for this authentication event", providerFound);
            return providerFound;
        }
        return null;
    }

    private Set<Event> checkRequireMultifactorProvidersForRequest(RequestContext context, RegisteredService service, Authentication authentication) {
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        String clientIp = clientInfo.getClientIpAddress();
        LOGGER.debug("Located client IP address as [{}]", (Object)clientIp);
        String agent = WebUtils.getHttpServletRequestUserAgentFromRequestContext((RequestContext)context);
        Map providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.applicationContext);
        Set<Map.Entry<String, String>> entries = this.multifactorMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String mfaMethod = entry.getKey().toString();
            String pattern = entry.getValue().toString();
            Optional<MultifactorAuthenticationProvider> providerFound = this.resolveProvider((Map<String, MultifactorAuthenticationProvider>)providerMap, mfaMethod);
            if (!providerFound.isPresent()) {
                LOGGER.error("Adaptive authentication is configured to require [{}] for [{}], yet [{}] is absent in the configuration.", new Object[]{mfaMethod, pattern, mfaMethod});
                throw new AuthenticationException();
            }
            if (AdaptiveMultifactorAuthenticationPolicyEventResolver.checkUserAgentOrClientIp(clientIp, agent, mfaMethod, pattern)) {
                return this.buildEvent(context, service, authentication, providerFound.get());
            }
            if (!this.checkRequestGeoLocation(context, clientIp, mfaMethod, pattern)) continue;
            return this.buildEvent(context, service, authentication, providerFound.get());
        }
        return null;
    }

    private boolean checkRequestGeoLocation(RequestContext context, String clientIp, String mfaMethod, String pattern) {
        String address;
        GeoLocationRequest location;
        GeoLocationResponse loc;
        if (this.geoLocationService != null && (loc = this.geoLocationService.locate(clientIp, location = WebUtils.getHttpServletRequestGeoLocationFromRequestContext((RequestContext)context))) != null && (address = loc.build()).matches(pattern)) {
            LOGGER.debug("Current address [{}] at [{}] matches the provided pattern [{}] for adaptive authentication and is required to use [{}]", new Object[]{address, clientIp, pattern, mfaMethod});
            return true;
        }
        return false;
    }

    private static boolean checkUserAgentOrClientIp(String clientIp, String agent, String mfaMethod, String pattern) {
        if (agent.matches(pattern) || clientIp.matches(pattern)) {
            LOGGER.debug("Current user agent [{}] at [{}] matches the provided pattern [{}] for adaptive authentication and is required to use [{}]", new Object[]{agent, clientIp, pattern, mfaMethod});
            return true;
        }
        return false;
    }

    private Set<Event> buildEvent(RequestContext context, RegisteredService service, Authentication authentication, MultifactorAuthenticationProvider provider) {
        if (provider.isAvailable(service)) {
            LOGGER.debug("Attempting to build an event based on the authentication provider [{}] and service [{}]", (Object)provider, (Object)service.getName());
            Event event = this.validateEventIdForMatchingTransitionInContext(provider.getId(), context, AdaptiveMultifactorAuthenticationPolicyEventResolver.buildEventAttributeMap(authentication.getPrincipal(), service, provider));
            return CollectionUtils.wrapSet((Object)event);
        }
        LOGGER.warn("Located multifactor provider [{}], yet the provider cannot be reached or verified", (Object)provider);
        return null;
    }

    @Override
    @Audit(action="AUTHENTICATION_EVENT", actionResolverName="AUTHENTICATION_EVENT_ACTION_RESOLVER", resourceResolverName="AUTHENTICATION_EVENT_RESOURCE_RESOLVER")
    public Event resolveSingle(RequestContext context) {
        return super.resolveSingle(context);
    }
}

